// =====================================================================
//  $Id: TSleepCommand.cc,v 1.2 2003/07/30 16:17:33 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TSleepCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSleepCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/system/sleep";
static const Tstring _desc = "sleep a parent process.\nsome thread processes go on.";

TSleepCommand::TSleepCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSleepCommand::~TSleepCommand()
{;}

Tvoid TSleepCommand::Execute( const TstringList& arguments )
{
  // ޤưƤʤ
  // åɤߤޤäƤޤ
  // SIGSTOPϡ
  if ( arguments.size() == 1 ) {
    Tpid_t parent = getpid();
    TUint timesec = strtoul( arguments[ 0 ].c_str(), 0, 0 );
    if ( fork() == 0 ) {
      sleep( timesec );
      exit( 0 );
    } else if ( getpid() == parent ) {
      wait( 0 );
    } else {
      return;
    }
  } else {
    ShowCommandDetail();
  }

  return;
}
