// =====================================================================
//  $Id: TDataElement.hh,v 1.2 2003/07/30 16:17:51 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TDataElement.hh,v $
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TDATAELEMENT_HH
#define __TDATAELEMENT_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataElement
  : public TStreamableObject
{

  private:
    Tvoid* theData;
    Telement_t theElementType;
    Tint theNumberOfPrimitives;

  public:
    TDataElement( Telement_t type = tTypeUnknown, const Tstring& id = TunknownID );
    TDataElement( Tvoid* data, Telement_t type, const Tstring& id = TunknownID, Tint ndata = 1 );
    TDataElement( const TDataElement& right );
    ~TDataElement();

  public:
    Tint Record( TOutputObjectStream* output );
    Tint GetRecordSize();
    Tvoid FillData( Tvoid* data, Telement_t elementtype, Tint ndata = 1 );
    Tvoid FillData( Tvoid* data, Tint ndata = 1 );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    Tint* GetIntData() const;
    Tstring* GetStringData() const;
    Tdouble* GetDoubleData() const;
    Tfloat* GetFloatData() const;
    TUshort* GetUnsignedShortData() const;
    Tshort* GetShortData() const;
    Tlong* GetLongData() const;
    TUlong* GetUnsignedLongData() const;
    TUint* GetUnsignedIntData() const;

  public:
    Tvoid* GetData() const;
    Telement_t GetElementType() const;
    Tint GetNumberOfPrimitives() const;
    Tvoid SetData( Tvoid* data );
    Tvoid SetElementType( Telement_t elementtype );
    Tvoid SetNumberOfPrimitives( Tint nprimitives );

  public:
    Tint StorePrimitives( Tint* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( Tstring* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( Tdouble* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( Tfloat* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( TUshort* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( Tshort* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( Tlong* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( TUlong* buffer, Tint narray = 0 ) const;
    Tint StorePrimitives( TUint* buffer, Tint narray = 0 ) const;

  public:
    const TDataElement& operator=( const TDataElement& right );
    Tbool operator==( const TDataElement& right ) const;
    Tbool operator!=( const TDataElement& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataElement& right );

  private:
    Tvoid freeDataSpace();
    Tvoid allocateDataSpace( Tvoid* data );
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

};

inline Tvoid* TDataElement::GetData() const
{
  return( theData );
}

inline Tvoid TDataElement::SetData( Tvoid* data )
{
  theData = data;
  return;
}

inline Telement_t TDataElement::GetElementType() const
{
  return( theElementType );
}

inline Tvoid TDataElement::SetElementType( Telement_t elementtype )
{
  theElementType = elementtype;
  return;
}

inline Tint TDataElement::GetNumberOfPrimitives() const
{
  return( theNumberOfPrimitives );
}

inline Tvoid TDataElement::SetNumberOfPrimitives( Tint nprimitives )
{
  theNumberOfPrimitives = nprimitives;
  return;
}

inline Tint* TDataElement::GetIntData() const
{
  return( (Tint*)theData );
}

inline Tstring* TDataElement::GetStringData() const
{
  return( (Tstring*)theData );
}

inline Tdouble* TDataElement::GetDoubleData() const
{
  return( (Tdouble*)theData );
}

inline Tfloat* TDataElement::GetFloatData() const
{
  return( (Tfloat*)theData );
}

inline TUshort* TDataElement::GetUnsignedShortData() const
{
  return( (TUshort*)theData );
}

inline Tshort* TDataElement::GetShortData() const
{
  return( (Tshort*)theData );
}

inline Tlong* TDataElement::GetLongData() const
{
  return( (Tlong*)theData );
}

inline TUlong* TDataElement::GetUnsignedLongData() const
{
  return( (TUlong*)theData );
}

inline TUint* TDataElement::GetUnsignedIntData() const
{
  return( (TUint*)theData );
}

inline Tvoid TDataElement::FillData( Tvoid* data, Telement_t elementtype, Tint ndata )
{
  freeDataSpace();
  theElementType = elementtype;
  theNumberOfPrimitives = ndata;
  allocateDataSpace( data );
  return;
}

inline Tvoid TDataElement::FillData( Tvoid* data, Tint ndata )
{
  return( FillData( data, theElementType, ndata ) );
}

#endif
