// =====================================================================
//  $Id: TCamacAdcModule.cc,v 1.2 2003/07/30 16:19:09 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TCamacAdcModule.cc,v $
//  Revision 1.2  2003/07/30 16:19:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCamacAdcModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacAdcModule::TCamacAdcModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacAdcModule::TCamacAdcModule( const TCamacAdcModule& right )
  : TCamacModule( right )
{;}

TCamacAdcModule::~TCamacAdcModule()
{;}

const TCamacAdcModule& TCamacAdcModule::operator=( const TCamacAdcModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacAdcModule::operator==( const TCamacAdcModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacAdcModule::operator!=( const TCamacAdcModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacAdcModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TCamacAdcModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read( channel );
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}
