// =====================================================================
//  $Id: TEnvironmentVariableTable.hh,v 1.2 2003/07/30 16:21:21 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TEnvironmentVariableTable.hh,v $
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TENVIRONMENTVARIABLETABLE_HH
#define __TENVIRONMENTVARIABLETABLE_HH

#include "Tglobals.h"

class TOutputHtmlFileStream;

class TEnvironmentVariableTable
{

  public:
    enum { tNotFound = -1 };

  private:
    TstringList theItemList;
    TstringList theValueList;
    Tint theNumberOfEnvironments;

  public:
    TEnvironmentVariableTable();
    TEnvironmentVariableTable( const Tstring& rcfile );
    TEnvironmentVariableTable( const TstringList& itemlist );
    TEnvironmentVariableTable( const TstringList& itemlist, const TstringList& valuelist );
    TEnvironmentVariableTable( const TEnvironmentVariableTable& right );
    ~TEnvironmentVariableTable();

  public:
    const TEnvironmentVariableTable& operator=( const TEnvironmentVariableTable& right );
    Tbool operator==( const TEnvironmentVariableTable& right ) const;
    Tbool operator!=( const TEnvironmentVariableTable& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TEnvironmentVariableTable& right );

  public:
    const TstringList& GetItemList() const;
    const TstringList& GetValueList() const;
    Tint GetNumberOfEnvironments() const;

  public:
    Tstring GetEnvironmentValue( const Tstring& item ) const;
    Tstring GetEnvironmentValue( Tint row ) const;
    Tstring GetEnvironmentItem( Tint row ) const;
    Tint FindEnvironmentItem( const Tstring& item ) const;
    Tint FindEnvironmentValue( const Tstring& value ) const;
    Tbool HasEnvironmentItem( const Tstring& item ) const;
    Tbool HasEnvironmentValue( const Tstring& value ) const;
    Tvoid UnsetEnvironment( const Tstring& item );
    Tvoid UnsetEnvironment( const TstringList& item );
    Tvoid SetEnvironment( const Tstring& item, const Tstring& value );
    Tvoid SetEnvironment( const TstringList& item, const TstringList& value );
    Tvoid SetEnvironment( const Tstring& rcfile );
    Tvoid ClearEnvironment();
    Tvoid ResetEnvironment();
    Tint GetIntegerValue( const Tstring& item ) const;
    Tdouble GetDoubleValue( const Tstring& item ) const;

};

inline const TstringList& TEnvironmentVariableTable::GetItemList() const
{
  return( theItemList );
}

inline const TstringList& TEnvironmentVariableTable::GetValueList() const
{
  return( theValueList );
}

inline Tint TEnvironmentVariableTable::GetNumberOfEnvironments() const
{
  return( theNumberOfEnvironments );
}

#endif
