// =====================================================================
//  $Id: bt00view.cc,v 1.2 2003/07/30 16:13:50 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: bt00view.cc,v $
//  Revision 1.2  2003/07/30 16:13:50  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();

  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );
  TDataRecord record;

  TCanvas adccanvas( "adc", "ADC #0" );
  TCanvas scalercanvas( "scaler", "SCALER #0-7" );

  TH1D adchist( "adc1Dhisto", "ADC #0", 400, 0, 4095 );
  TH1D scalerhist( "scaler1Dhisto", "SCALER #0-7", 8, 0, 8 );
  adchist.Draw();
  scalerhist.Draw();

  Tstring adcidset[ 3 ] = { "EVENT", "ADC", "0" };
  Tstring scaleridset[ 2 ] = { "EVENT", "SCALER" };

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }
    Tstring recid = record.GetID();


    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "CSI EVENT" ) {

      TDataElement element;
      record.FindDataElement( adcidset, element );
      TUint count = *( element.GetUnsignedIntData() );
      adchist.Fill( (Tdouble)count );
      adccanvas.Modified();
      adccanvas.Update();

    } else if ( recid == "SCALER EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( scaleridset, segment );
      for ( Tint i = 0; i < 8; i ++ ) {
	TDataElement element = segment[ i ];
	TUint count = *( element.GetUnsignedIntData() );
	scalerhist.Fill( (Tdouble)i, (Tdouble)count );
      }
      scalercanvas.Modified();
      scalercanvas.Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApplication -> Run();

  return( 0 );
}
