// =====================================================================
//  $Id: OFFminushoc.cc,v 1.2 2003/07/30 16:15:51 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: OFFminushoc.cc,v $
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St00DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );
  gROOT -> Reset( 0 );
  gStyle -> SetStatColor( 42 );
  gStyle -> SetTitleColor( 42 );
  gStyle -> SetFrameFillColor( 21 );
  gStyle -> SetFrameFillStyle( 1 );
  gStyle -> SetMarkerStyle( 7 );
  gStyle -> SetFuncColor( 4 );
  gStyle -> SetOptStat( 1111110 );
  gStyle -> SetOptFit( 1111 );
  gStyle -> SetPadGridX( kTRUE );
  gStyle -> SetPadGridY( kTRUE );
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "H.O.C subtracted", 500, -1000.0, 4096.0 );
  mpx201a.SetFillColor( 45 );






  St00DataRecordConversion conversion;
  TDataRecord r;
  Tstring ifname = argv[ 1 ];
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> r ) != 0 ) {
    TDataMultiplicity& map = conversion.Convert( r );
    if ( conversion.IsSuccess() ) {
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  mpx201a.Fill( map[ row ][ col ] );
	} 
      }
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return( 0 );
}
