// =====================================================================
//  $Id: St00EventAction.cc,v 1.2 2003/07/30 16:15:51 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: St00EventAction.cc,v $
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"

#include "St00EventAction.hh"
#include "St00RunAction.hh"
#include "St00RunSummary.hh"

St00EventAction::St00EventAction()
{;}

St00EventAction::~St00EventAction()
{;}

TReadoutList* St00EventAction::WaitEvent()
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST00_RPV130_OUT_VETO" );
  Tint open = envtable.GetIntegerValue( "ST00_RPV130_OUT_OPEN" );

  Tbool trigger = Tfalse;

  do {
    if ( mpx201a -> IsMemoryBlockFull() ) {
      trigger = Ttrue;
    } else {
      continue;
    }
  } while ( trigger == Tfalse );

  rpv130 -> LevelUp( veto );
  rpv130 -> Pulse( open );

  //mpx201a -> SetBufferOrientation( 1 );
  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid St00EventAction::BeginOfEventAction( TEvent& anEvent )
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST00_RPV130_OUT_VETO" );

  mpx201a -> EnableAcquisition();

  rpv130 -> LevelDown( veto );

  return;
}

Tvoid St00EventAction::EndOfEventAction( TEvent& anEvent )
{
  St00RunAction* action =
    (St00RunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );


  TDataRecord record = anEvent.GetDataRecord();
  *ofile << record;

  fillEventInformation( record );
  theCrate -> Update( "event" );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint stop = envtable.GetIntegerValue( "ST00_RPV130_OUT_STOP" );

  mpx201a -> NextEventProcedure();
  rpv130 -> Pulse( stop );
  return;
}

Tvoid St00EventAction::fillEventInformation( const TDataRecord& record )
{
  St00RunAction* action = (St00RunAction*)( theRunManager -> GetRunAction() );
  St00RunSummary* summary = action -> GetRunSummary();
  Tint nevent = summary -> GetNumberOfEvents();
  summary -> SetNumberOfEvents( ++ nevent );

  return;
}
