// =====================================================================
//  $Id: OFFtest.cc,v 1.2 2003/07/30 16:16:33 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: OFFtest.cc,v $
//  Revision 1.2  2003/07/30 16:16:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St02OfflineDarkAverageMap.hh"
#include "St02OfflineDarkRmsMap.hh"
#include "St02SinglePixelInterface.hh"
#include "St02SinglePixelList.hh"
#include "St02DataRecordConversion.hh"
#include "St02RunInformationExtractor.hh"
#include "St02BadChannelMap.hh"

int main( int argc, char** argv, char** envv )
{

  TApplication* theApplication = rootinit();
  TCanvas CVspfind( "CVspfind", "Findout SINGLE PIXEL EVENTs", 720, 810 );
  CVspfind.ToggleEventStatus();
  CVspfind.Divide( 2, 3 );
//   //󥰥ԥ륤٥ȤΥʥADC
//   TH1D H1Dsignal( "H1Dsignal", "Single Pixel Event subtracted D.C.", 100, 0.0, 500.0 );
//   //Υԥ˱ȤADCȤʿ
//   //Ʊ饤H.O.C.ʿѤϰƤ
  TH1D H1Ddrk( "H1Ddrk", "Dark Current subtracted H.O.C.", 100, -50.0, 50.0 );
//   //Υԥ˱RMSADCȤʿ
  TH1D H1Drms( "H1Drms", "RMS of D.C.", 50, 0.0, 50.0 );

  St02BadChannelMap map( argv[ 1 ] );
  const TDataMultiplicity& bad = map.GetMap();
  const TDataMultiplicity& rms = map.GetOfflineDarkRmsMap().GetMap();
  const TDataMultiplicity& ave = map.GetOfflineDarkRmsMap().GetOfflineDarkAverageMap().GetMap();

  Tcout << "BAD PIXEL(s) find " << map.GetNumberOfBadChannels() << Tendl;
  for ( Tint row = 0; row < bad.num_row(); row ++ ) {
    for ( Tint col = 0; col < bad.num_col(); col ++ ) {
      if ( bad[ row ][ col ] == 1.0 ) {
        Tcout << row << "," << col << ": " << bad[ row ][ col ] << Tendl;
        Tcout << ave[ row ][ col ] << Tendl;
        Tcout << rms[ row ][ col ] << Tendl;
      }
    }
  }





  for ( Tint row = 0; row < ave.num_row(); row ++ ) {
    for ( Tint col = 0; col < ave.num_col(); col ++ ) {
      //if ( badmap.IsGoodChannel( row, col ) ) {
      H1Ddrk.Fill( ave[ row ][ col ] );
      H1Drms.Fill( rms[ row ][ col ] );
      //}
    }
  }

  CVspfind.cd(1);
  H1Ddrk.Draw();
  CVspfind.cd(2);
  H1Drms.Draw();
  CVspfind.cd();

  theApplication -> Run();
  //theApplication -> Terminate();

  return( 0 );
}
