// =====================================================================
//  $Id: TAddRunInformationModuleCommand.cc,v 1.2 2003/07/30 16:17:30 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TAddRunInformationModuleCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TAddRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/addinfo";
static const Tstring _desc = "add run information into the table.";

TAddRunInformationModuleCommand::TAddRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TAddRunInformationModuleCommand::~TAddRunInformationModuleCommand()
{;}

Tvoid TAddRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }

  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();
  table.AddRunInformation();

  return;
}
