// =====================================================================
//  $Id: TAnalysisStartCommand.cc,v 1.2 2003/07/30 16:17:30 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TAnalysisStartCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TAnalysisStartCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/start";
static const Tstring _desc = "start an analysis.";

TAnalysisStartCommand::TAnalysisStartCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStartCommand::~TAnalysisStartCommand()
{;}

Tvoid TAnalysisStartCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StartAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StartAnalysis( arguments[ i ] );
  }
  return;
}
