// =====================================================================
//  $Id: TPrintCurrentWorkingDirectoryCommand.cc,v 1.2 2003/07/30 16:17:31 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TPrintCurrentWorkingDirectoryCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TPrintCurrentWorkingDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "pwd";
static const Tstring _desc = "print the absolute pathname of the current working directory.";

TPrintCurrentWorkingDirectoryCommand::TPrintCurrentWorkingDirectoryCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TPrintCurrentWorkingDirectoryCommand::~TPrintCurrentWorkingDirectoryCommand()
{;}

Tvoid TPrintCurrentWorkingDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  static const Tstring head = "TPrintCurrentWorkingDirectoryCommand::Execute: ";
  if ( ui ) {
    Tcout << ui -> GetCurrentWorkingDirectory() << Tendl;
  } else {
    Tcerr << head << "UserInterface doesn't exist." << Tendl;
  }
  return;
}
