// =====================================================================
//  $Id: TReadoutSpecified.cc,v 1.2 2003/07/30 16:20:11 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TReadoutSpecified.cc,v $
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutSpecified.hh"

TReadoutSpecified::TReadoutSpecified()
  : theListID(), theReadoutList( 0 )
{;}

TReadoutSpecified::TReadoutSpecified( const Tstring& id, TReadoutList* list )
  : theListID( id ), theReadoutList( list )
{;}

TReadoutSpecified::TReadoutSpecified( const TReadoutSpecified& right )
  : theListID( right.theListID ), theReadoutList( right.theReadoutList )
{;}

TReadoutSpecified::~TReadoutSpecified()
{;}

const TReadoutSpecified& TReadoutSpecified::operator=( const TReadoutSpecified& right )
{
  theListID = right.theListID;
  theReadoutList = right.theReadoutList;
  return( *this );
}

Tbool TReadoutSpecified::operator==( const TReadoutSpecified& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theListID == right.theListID );
  retval &= ( theReadoutList == right.theReadoutList );
  return( retval );
}

Tbool TReadoutSpecified::operator!=( const TReadoutSpecified& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theListID != right.theListID );
  retval |= ( theReadoutList != right.theReadoutList );
  return( retval );
}

Tostream& operator<<( Tostream& tos, const TReadoutSpecified& right )
{
  tos << "ID: " << right.theListID << ", " << right.theReadoutList << Tflush;
  return( tos );
}
