// =====================================================================
//  $Id: TRunInformation.hh,v 1.2 2003/07/30 16:20:30 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TRunInformation.hh,v $
//  Revision 1.2  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TRUNINFORMATION_HH
#define __TRUNINFORMATION_HH

#include "Tglobals.h"

class TOutputHtmlFileStream;

class TRunInformation
{

  private:
    Truninfo_t theInformationType;
    Tstring theItem;
    Tstring theDefaultValue;
    Tstring theValue;
    TstringList theSelectableList;

  public:
    TRunInformation();
    TRunInformation( const Tstring& item );
    TRunInformation( const Tstring& item, Truninfo_t type );
    TRunInformation( const Tstring& item, const TstringList& list );
    TRunInformation( const Tstring& item, const Tstring& value );
    TRunInformation( const Tstring& item, const Tstring& value, Truninfo_t type );
    TRunInformation( const Tstring& item, const Tstring& value, const TstringList& list );
    TRunInformation( const TRunInformation& right );
    ~TRunInformation();

  public:
    const TRunInformation& operator=( const TRunInformation& right );
    Tbool operator==( const TRunInformation& right ) const;
    Tbool operator!=( const TRunInformation& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TRunInformation& right );
    friend TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& html, const TRunInformation& right );
    friend Tvoid SetInformation( TRunInformation& info );

  public:
    Truninfo_t GetInformationType() const;
    const Tstring& GetItem() const;
    const Tstring& GetDefaultValue() const;
    const Tstring& GetValue() const;
    const TstringList& GetSelectableList() const;
    Tvoid SetInformationType( Truninfo_t info );
    Tvoid SetItem( const Tstring& item );
    Tvoid SetDefaultValue( const Tstring& value );
    Tvoid SetValue( const Tstring& value );
    Tvoid SetSelectableList( const TstringList& list );

  public:
    Tvoid Clear();

  private:
    Tvoid setFreeValue();
    Tvoid setSelectableValue();
    Tvoid setFreeText();
    Tvoid setInformation();

};

inline Truninfo_t TRunInformation::GetInformationType() const
{
  return( theInformationType );
}

inline const Tstring& TRunInformation::GetItem() const
{
  return( theItem );
}

inline const Tstring& TRunInformation::GetDefaultValue() const
{
  return( theDefaultValue );
}

inline const Tstring& TRunInformation::GetValue() const
{
  return( theValue );
}

inline const TstringList& TRunInformation::GetSelectableList() const
{
  return( theSelectableList );
}

inline Tvoid TRunInformation::SetInformationType( Truninfo_t info )
{
  theInformationType = info;
  return;
}

inline Tvoid TRunInformation::SetItem( const Tstring& item )
{
  theItem = item;
  return;
}

inline Tvoid TRunInformation::SetDefaultValue( const Tstring& value )
{
  theDefaultValue = value;
  return;
}

inline Tvoid TRunInformation::SetValue( const Tstring& value )
{
  theValue = value;
  return;
}

inline Tvoid TRunInformation::SetSelectableList( const TstringList& list )
{
  theSelectableList = list;
  theInformationType = tInfoSelectableValue;
  return;
}

#endif
