// =====================================================================
//  $Id: TRunManager.hh,v 1.16 2003/07/30 17:46:19 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TRunManager.hh,v $
//  Revision 1.16  2003/07/30 17:46:19  goiwai
//  Tint GetRunID() const;
//  Tvoid SetRunID( Tint id );
//  ɲäޤ.
//
//  Revision 1.15  2003/07/30 16:20:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TRUNMANAGER_HH
#define __TRUNMANAGER_HH

#include "Tglobals.h"
#include "TRun.hh"
#include "TSystemTimer.hh"
#include "TSystemClock.hh"
#include "TEnvironmentVariableTable.hh"

class TUserInterface;
class TCommand;
class TSystemAction;
class TRunAction;
class TEventAction;
class TEventManager;
class TSoftwareRunInformationModule;
class TAnalysisManager;
class TSystemTimer;
class TReadoutBookDefinition;
class TReadoutBook;
class TCrateDefinition;
class TCrate;

class TRunManager
{

  protected:
    static TRunManager* theRunManager;

  protected:
    Tstatus_t theStatus;
    TRun theRun;
    TSystemAction* theSystemAction;
    TRunAction* theRunAction;
    TEventManager* theEventManager;
    TUserInterface* theUserInterface;
    Tthread_t theThreadOfEventLoop;
    TSoftwareRunInformationModule* theRunInformationModule;
    TAnalysisManager* theAnalysisManager;
    TSystemTimer theRunTimer;
    TSystemClock theRunClock;
    TReadoutBookDefinition* theReadoutBookDefinition;
    TReadoutBook* theReadoutBook;
    TCrateDefinition* theCrateDefinition;
    TCrate* theCrate;
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theEventLimit;

  public:
    TRunManager( TUserInterface* ui = 0 );
    virtual ~TRunManager();

  public:
    TUserInterface* GetUserInterface() const;
    const TRun& GetRun() const;
    TRun& GetRun();
    Tint GetRunID() const;
    Tvoid SetRunID( Tint id );
    TSystemAction* GetSystemAction() const;
    TRunAction* GetRunAction() const;
    TEventManager* GetEventManager() const;
    Tvoid SetUserInterface( TUserInterface* ui );
    Tint SetUserCommand( TCommand* command );
    Tvoid SetRun( const TRun& run );
    Tvoid SetSystemAction( TSystemAction* action );
    Tvoid SetRunAction( TRunAction* action );
    Tvoid SetEventAction( TEventAction* action );
    Tvoid SetEventManager( TEventManager* manager );
    Tstatus_t GetStatus() const;
    Tvoid SetStatus( Tstatus_t status );
    Tthread_t GetThreadOfEventLoop() const;
    Tvoid SetThreadOfEventLoop( Tthread_t thread );
    TSoftwareRunInformationModule* GetRunInformationModule() const;
    TAnalysisManager* GetAnalysisManager() const;
    const TSystemTimer& GetRunTimer() const;
    TSystemTimer& GetRunTimer();
    Tvoid SetRunTimer( const TSystemTimer& timer );
    const TSystemClock& GetRunClock() const;
    TSystemClock& GetRunClock();
    Tvoid SetRunClock( const TSystemClock& clock );
    TReadoutBookDefinition* GetReadoutBookDefinition() const;
    TReadoutBook* GetReadoutBook() const;
    TCrateDefinition* GetCrateDefinition() const;
    TCrate* GetCrate() const;
    Tvoid SetReadoutBookDefinition( TReadoutBookDefinition* definition );
    Tvoid SetCrateDefinition( TCrateDefinition* definition );
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;
    TEnvironmentVariableTable& GetEnvironmentVariableTable();
    Tvoid SetEnvironmentVariableTable( const TEnvironmentVariableTable& table );
    Tint GetEventLimit() const;
    Tvoid SetEventLimit( Tint nevents );

  public:
    virtual Tvoid SessionStart();
    virtual Tvoid ShowStatus() const;
    virtual Tvoid PopupLogo() const;
    virtual Tvoid PopdownLogo() const;
    virtual Tvoid PrintAuthorInformation( Tostream& tos = Tcout ) const;
    virtual Tvoid ShutdownRun();
    virtual Tvoid StartRun();
    virtual Tvoid StartRun( Tint runid );
    virtual Tvoid StopRun();
    virtual Tvoid SuspendRun();
    virtual Tvoid ResumeRun();
    virtual Tvoid SetRunInformationModule( TSoftwareRunInformationModule* module );
    virtual Tvoid SetRunInformationModule( const Tstring& id );
    virtual Tvoid SetRunInformationModule( Tint slot );
    virtual Tvoid SetAnalysisManager( TAnalysisManager* manager );

  public:
    static TRunManager* GetRunManager();

  protected:
    static Tvoid* doEventLoop( Tvoid* arguments );
    static Tvoid* showLogo( Tvoid* arguments );
    static Tvoid catchAlarmSignal( Tint sigid );

  public:
    virtual Tvoid GoEventLoop();
    virtual Tvoid WaitReturnFromEventLoop();

  protected:
    virtual TstringList divide( const Tstring& input ) const;
    virtual Tvoid installDefaultCommand();

};

inline TRunManager* TRunManager::GetRunManager()
{
  return( theRunManager );
}

inline TUserInterface* TRunManager::GetUserInterface() const
{
  return( theUserInterface );
}

inline Tvoid TRunManager::SetRun( const TRun& run )
{
  theRun = run;
  return;
}

inline const TRun& TRunManager::GetRun() const
{
  return( theRun );
}

inline TRun& TRunManager::GetRun()
{
  return( theRun );
}

inline Tint TRunManager::GetRunID() const
{
  return( theRun.GetRunID() );
}

inline Tvoid TRunManager::SetRunID( Tint id )
{
  theRun.SetRunID( id );
  return;
}

inline TSystemAction* TRunManager::GetSystemAction() const
{
  return( theSystemAction );
}

inline TRunAction* TRunManager::GetRunAction() const
{
  return( theRunAction );
}

inline TEventManager* TRunManager::GetEventManager() const
{
  return( theEventManager );
}

inline Tstatus_t TRunManager::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TRunManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline Tthread_t TRunManager::GetThreadOfEventLoop() const
{
  return( theThreadOfEventLoop );
}

inline Tvoid TRunManager::SetThreadOfEventLoop( Tthread_t thread )
{
  theThreadOfEventLoop = thread;
  return;
}

inline TSoftwareRunInformationModule* TRunManager::GetRunInformationModule() const
{
  return( theRunInformationModule );
}

inline TAnalysisManager* TRunManager::GetAnalysisManager() const
{
  return( theAnalysisManager );
}

inline const TSystemTimer& TRunManager::GetRunTimer() const
{
  return( theRunTimer );
}

inline TSystemTimer& TRunManager::GetRunTimer()
{
  return( theRunTimer );
}

inline TReadoutBookDefinition* TRunManager::GetReadoutBookDefinition() const
{
  return( theReadoutBookDefinition );
}

inline TReadoutBook* TRunManager::GetReadoutBook() const
{
  return( theReadoutBook );
}

inline TCrateDefinition* TRunManager::GetCrateDefinition() const
{
  return( theCrateDefinition );
}

inline TCrate* TRunManager::GetCrate() const
{
  return( theCrate );
}

inline Tvoid TRunManager::SetRunTimer( const TSystemTimer& timer )
{
  theRunTimer = timer;
  return;
}

inline const TEnvironmentVariableTable& TRunManager::GetEnvironmentVariableTable() const
{
  return( theEnvironmentVariableTable );
}

inline TEnvironmentVariableTable& TRunManager::GetEnvironmentVariableTable()
{
  return( theEnvironmentVariableTable );
}

inline Tvoid TRunManager::SetEnvironmentVariableTable( const TEnvironmentVariableTable& table )
{
  theEnvironmentVariableTable = table;
  return;
}

inline const TSystemClock& TRunManager::GetRunClock() const
{
  return( theRunClock );
}

inline TSystemClock& TRunManager::GetRunClock()
{
  return( theRunClock );
}

inline Tvoid TRunManager::SetRunClock( const TSystemClock& clock )
{
  theRunClock = clock;
  return;
}

inline Tint TRunManager::GetEventLimit() const
{
  return( theEventLimit );
}

inline Tvoid TRunManager::SetEventLimit( Tint nevents )
{
  theEventLimit = nevents;
  return;
}

#endif
