// =====================================================================
//  $Id: TOutputHtmlFileStream.hh,v 1.3 2003/07/30 16:21:21 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TOutputHtmlFileStream.hh,v $
//  Revision 1.3  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TOUTPUTHTMLFILESTREAM_HH
#define __TOUTPUTHTMLFILESTREAM_HH

#include "Tglobals.h"

class TOutputHtmlFileStream
  : public Tofstream
{

  public:
    enum {
      fopen = 0x01,
      fclose = 0x02,
      otable = 0x04, 
      ctable = 0x08, 
      wheader = 0x10, 
      wfooter = 0x20,
      title = 0x40
    };

  protected:
    Tint theStatus;
    Tstring theTitle;
    Tstring theFileName;

  public:
    TOutputHtmlFileStream();
    TOutputHtmlFileStream( const Tstring& filename );
    TOutputHtmlFileStream( const Tstring& filename, const Tstring& title );
    ~TOutputHtmlFileStream();

  public:
    virtual TOutputHtmlFileStream& WriteHeader();
    virtual TOutputHtmlFileStream& WriteFooter();
    virtual TOutputHtmlFileStream& OpenTable();
    virtual TOutputHtmlFileStream& CloseTable();

  public:
    Tbool IsOpen() const;
    Tbool IsClose() const;
    Tbool IsOpenTable() const;
    Tbool IsCloseTable() const;
    Tbool IsWrittenHeader() const;
    Tbool IsWrittenFooter() const;
    Tbool HasTitle() const;

  public:
    const Tstring& GetTitle() const;
    Tint GetStatus() const;
    const Tstring& GetFileName() const;
    Tvoid SetTitle( const Tstring& title );
    Tvoid SetStatus( Tint status );

  public:
    Tvoid Open( const Tstring& filename );
    Tvoid Open( const Tstring& filename, const Tstring& title );
    Tvoid Close();

  protected:
    Tint setStatusBit( Tint status );
    Tint clearStatusBit( Tint status );

};

inline const Tstring& TOutputHtmlFileStream::GetTitle() const
{
  return( theTitle );
}

inline Tint TOutputHtmlFileStream::GetStatus() const
{
  return( theStatus );
}

inline const Tstring& TOutputHtmlFileStream::GetFileName() const
{
  return( theFileName );
}

inline Tvoid TOutputHtmlFileStream::SetTitle( const Tstring& title )
{
  theTitle = title;
  setStatusBit( TOutputHtmlFileStream::title );
  return;
}

inline Tvoid TOutputHtmlFileStream::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tint TOutputHtmlFileStream::setStatusBit( Tint status )
{
  return( theStatus |= status );
}

inline Tint TOutputHtmlFileStream::clearStatusBit( Tint status )
{
  return( theStatus &= ~status );
}

inline Tbool TOutputHtmlFileStream::IsOpen() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::fopen ) );
}

inline Tbool TOutputHtmlFileStream::IsClose() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::fclose ) );
}

inline Tbool TOutputHtmlFileStream::IsOpenTable() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::otable ) );
}

inline Tbool TOutputHtmlFileStream::IsCloseTable() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::ctable ) );
}

inline Tbool TOutputHtmlFileStream::IsWrittenHeader() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::wheader ) );
}

inline Tbool TOutputHtmlFileStream::IsWrittenFooter() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::wfooter ) );
}

inline Tbool TOutputHtmlFileStream::HasTitle() const
{
  return( (Tbool)( theStatus & TOutputHtmlFileStream::title ) );
}

#endif
