// =====================================================================
//  $Id: decompress.cc,v 1.2 2003/07/30 16:21:38 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: decompress.cc,v $
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataInflation.hh"

int main( int argc, char** argv, char** envv )
{
#ifdef __CLDAQ_ZLIB_USE
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <input> <output>" << Tendl;
    return( -1 );
  }
  const Tstring ifname = argv[ 1 ];
  const Tstring ofname = argv[ 2 ];

  TDataInflation inflation;

  const Tint bufsize = 256;
  Tbyte* input[ bufsize ];

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( (Tchar*)input, bufsize );
    inflation.Decompress( input, ifs.gcount() );
    ofs.write( (Tchar*)inflation.GetInflatedData(), inflation.GetSizeOfInflatedData() );
  }

  ifs.close();
  ofs.close();
#endif
  return( 0 );
}
