// =====================================================================
//  $Id: mm2700.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: mm2700.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRs232cKeithley2700Module.hh"
#include "TDataElement.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<device>" << Tendl;
    Tcerr << "ex) " << argv[ 0 ] << " /dev/ttyS0 (linux typical)" << Tendl;
    return( -1 );
  }
  const Tstring devpath = argv[ 1 ];
  const Tint nevent = 10;
  TRs232cKeithley2700Module mm2700;
  mm2700.Initialize();
  TDataElement e;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    mm2700.FillData( e, 0 );
    mm2700.Clear();
    Tcout << e << Tendl;
    sleep( 1 );
  }
  mm2700.Close();
  bench.Stop();
  Tcout << bench << Tendl;
  return( 0 );
}
