// =====================================================================
//  $Id: osocket.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: osocket.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSocket.hh"
#include "TBenchmark.hh"

#include "testrecord.h"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exHost, exPort, exNumberOfEvents, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ];
    Tcerr << Tspace << "<host>";
    Tcerr << Tspace << "<port>";
    Tcerr << Tspace << "<nevent>";
    Tcerr << Tendl;
    return( -1 );
  }
  const Tstring hostname = argv[ exHost ];
  const Tint port = atoi( argv[ exPort ] );
  const Tint nevent = atoi( argv[ exNumberOfEvents ] );
  TOutputObjectSocket osocket( hostname, port );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    osocket << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << osocket.GetTotalDataSize();
  Tcout << " byte data has been send to " << hostname << "." << Tendl;

  return( 0 );
}
