// =====================================================================
//  $Id: Rs01CrateDefinition.cc,v 1.2 2003/07/30 16:14:41 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: Rs01CrateDefinition.cc,v $
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TRs232cKeithley7702Module.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "TRunInformationTable.hh"
#include "Rs01CrateDefinition.hh"


Rs01CrateDefinition::Rs01CrateDefinition()
  : TCrateDefinition()
{;}

Rs01CrateDefinition::~Rs01CrateDefinition()
{;}

TCrate* Rs01CrateDefinition::Define()
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring dev = envtable.GetEnvironmentValue( "RS01_KEITHLEY_DEVICE" );
  Tint npin = envtable.GetIntegerValue( "RS01_KEITHLEY_CHANNEL" );


  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "REAL RUN" );
  selectlist.push_back( "TEST RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable table( infolist );


  TCrate* crate = new TCrate();
  TSoftwareRunInformationModule* runinfo =
    new TSoftwareRunInformationModule( table );
  crate -> InstallModule( runinfo, "RUN INFO" );
  theRunManager -> SetRunInformationModule( runinfo );

  crate -> InstallModule( new TRs232cKeithley7702Module( dev ), "MODEL 7702" );
  crate -> InstallModule( new TSoftwareClockModule(), "CLOCK" );

  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring modid = "TIMER" + itostr( i, 2 );
    crate -> InstallModule( new TSoftwareTimerModule(), modid );
  }

  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "EVENT ID" );
  return( crate );
}
