// =====================================================================
//  $Id: TSetEnvironmentVariableCommand.cc,v 1.2 2003/07/30 16:17:32 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TSetEnvironmentVariableCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSetEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "setenv";
static const Tstring _desc = "change or add an environment variable.\nexample> setenv ITEM value\nexample> setenv rcfile";

TSetEnvironmentVariableCommand::TSetEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TSetEnvironmentVariableCommand::~TSetEnvironmentVariableCommand()
{;}

Tvoid TSetEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TSetEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcerr << head << "select no item and no value." << Tendl;
    ShowCommandDetail();
  } else if ( arguments.size() == 1 ) {
    theEnvironmentVariableTable -> SetEnvironment( arguments[ 0 ] );
  } else if ( arguments.size() == 2 ) {
    theEnvironmentVariableTable -> SetEnvironment( arguments[ 0 ], arguments[ 1 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}
