// =====================================================================
//  $Id: TReadoutElement.hh,v 1.3 2003/07/30 16:20:11 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TReadoutElement.hh,v $
//  Revision 1.3  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TREADOUTELEMENT_HH
#define __TREADOUTELEMENT_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"

class TModule;
class TDataElement;

class TReadoutElement
  : public TReadoutIdentification
{

  private:
    TModule* theModule;
    Tint theChannelNumber;

  public:
    TReadoutElement( TModule* module, const Tstring& id = TunknownID, Tint ch = -1 );
    TReadoutElement( TModule* module, Tint ch, const Tstring& id = TunknownID );
    TReadoutElement( const TReadoutElement& right );
    ~TReadoutElement();

  public:
    const TReadoutElement& operator=( const TReadoutElement& right );
    Tbool operator==( const TReadoutElement& right ) const;
    Tbool operator!=( const TReadoutElement& right ) const;

  public:
    TDataElement Read();
    TDataElement Read( Tint ch );

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );
    Tint GetChannelNumber() const;
    Tvoid SetChannelNumber( Tint ch );

};

inline TModule* TReadoutElement::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutElement::SetModule( TModule* module )
{
  theModule = module;
  return;
}

inline Tint TReadoutElement::GetChannelNumber() const
{
  return( theChannelNumber );
}

inline Tvoid TReadoutElement::SetChannelNumber( Tint ch )
{
  theChannelNumber = ch;
  return;
}

#endif
