// =====================================================================
//  $Id: TReadoutSpecified.hh,v 1.2 2003/07/30 16:20:11 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TReadoutSpecified.hh,v $
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TREADOUTSPECIFIED_HH
#define __TREADOUTSPECIFIED_HH

#include "Tglobals.h"

class TReadoutList;

class TReadoutSpecified
{

  private:
    Tstring theListID;
    TReadoutList* theReadoutList;

  public:
    TReadoutSpecified();
    TReadoutSpecified( const Tstring& id, TReadoutList* list );
    TReadoutSpecified( const TReadoutSpecified& right );
    ~TReadoutSpecified();

  public:
    const TReadoutSpecified& operator=( const TReadoutSpecified& right );
    Tbool operator==( const TReadoutSpecified& right ) const;
    Tbool operator!=( const TReadoutSpecified& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutSpecified& right );

  public:
    const Tstring& GetListID() const;
    Tstring& GetListID();
    TReadoutList* GetReadoutList() const;
    Tvoid SetListID( const Tstring& id );
    Tvoid SetReadoutList( TReadoutList* list );

};

inline const Tstring& TReadoutSpecified::GetListID() const
{
  return( theListID );
}

inline Tstring& TReadoutSpecified::GetListID()
{
  return( theListID );
}

inline TReadoutList* TReadoutSpecified::GetReadoutList() const
{
  return( theReadoutList );
}

inline Tvoid TReadoutSpecified::SetListID( const Tstring& id )
{
  theListID = id;
  return;
}

inline Tvoid TReadoutSpecified::SetReadoutList( TReadoutList* list )
{
  theReadoutList = list;
  return;
}

#endif
