// =====================================================================
//  $Id: TDataInflation.cc,v 1.2 2003/07/30 16:21:20 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TDataInflation.cc,v $
//  Revision 1.2  2003/07/30 16:21:20  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifdef __CLDAQ_ZLIB_USE
#include "TDataInflation.hh"

TDataInflation::TDataInflation( Tint bufsize )
  : theInflationStream(), 
    theStatus( Z_OK ),
    theOutputBuffer( 0 ), theSizeOfOutputBuffer( bufsize ),
    theInflatedData( 0 ), theSizeOfInflatedData( -1 )
{
  theInflationStream.zalloc = Z_NULL;
  theInflationStream.zfree = Z_NULL;
  theInflationStream.opaque = Z_NULL;

  theInflationStream.next_in = Z_NULL;
  theInflationStream.avail_in = 0;
  theInflationStream.next_out = Z_NULL;
  theInflationStream.avail_out = 0;

  theStatus = inflateInit( &theInflationStream );
  if ( theStatus != Z_OK ) {
    Tcerr << "TDataInflation::TDataInflation: ";
    Tcerr << theInflationStream.msg << ", status: " << theStatus << Tendl;
  }

  SetOutputBuffer( theSizeOfOutputBuffer );
}

TDataInflation::TDataInflation( const TDataInflation& right )
  : theInflationStream(), 
    theStatus( Z_OK ),
    theOutputBuffer( 0 ), theSizeOfOutputBuffer( right.theSizeOfOutputBuffer ),
    theInflatedData( 0 ), theSizeOfInflatedData( -1 )
{
  theInflationStream.zalloc = Z_NULL;
  theInflationStream.zfree = Z_NULL;
  theInflationStream.opaque = Z_NULL;

  theInflationStream.next_in = Z_NULL;
  theInflationStream.avail_in = 0;
  theInflationStream.next_out = Z_NULL;
  theInflationStream.avail_out = 0;

  theStatus = inflateInit( &theInflationStream );
  if ( theStatus != Z_OK ) {
    Tcerr << "TDataInflation::TDataInflation: ";
    Tcerr << theInflationStream.msg << ", status: " << theStatus << Tendl;
  }

  SetOutputBuffer( theSizeOfOutputBuffer );  
}

TDataInflation::~TDataInflation()
{
  theStatus = inflateEnd( &theInflationStream );
  if ( theStatus != Z_OK ) {
    Tcerr << "TDataInflation::~TDataInflation: ";
    Tcerr << theInflationStream.msg << ", status: " << theStatus << Tendl;
  }
  delete [] theOutputBuffer;
}
const TDataInflation& TDataInflation::operator=( const TDataInflation& right )
{
  theInflationStream = right.theInflationStream;
  theStatus = right.theStatus;
  theSizeOfOutputBuffer = right.theSizeOfOutputBuffer;
  delete [] (Tbyte*)theOutputBuffer;
  theOutputBuffer = new Tbyte[ theSizeOfOutputBuffer ];
  theInflatedData = 0;
  theSizeOfInflatedData = -1;
  return( *this );
}

Tvoid TDataInflation::Decompress( Tvoid* input, Tint nbyte )
{
  static const Tstring head = "TDataInflation::Decompress: ";

  theInflationStream.next_in = (Tbyte*)input;
  theInflationStream.avail_in = nbyte;
  theInflationStream.next_out = theOutputBuffer;
  theInflationStream.avail_out = theSizeOfOutputBuffer;

  theStatus = inflate( &theInflationStream, Z_NO_FLUSH );

  theInflatedData = theOutputBuffer;
  theSizeOfInflatedData = theSizeOfOutputBuffer - theInflationStream.avail_out;

  return;
}

Tvoid TDataInflation::SetOutputBuffer( Tint bufsize )
{
  if ( theOutputBuffer ) {
    delete [] theOutputBuffer;
  }
  theOutputBuffer = new Tbyte[ bufsize ];
  return;
}

#endif
