// =====================================================================
//  $Id: sw00fadcview.cc,v 1.2 2003/07/30 16:15:16 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: sw00fadcview.cc,v $
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();

  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );


  TCanvas canvas( "adc", "Flash ADC", 640, 640 );

  Tstring idset[ 2 ] = { "Event Data", "Flash ADC" };
  TDataRecord record;

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }

    Tstring recid = record.GetID();


    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {

      TH2D fadc( "fadc", "FADC Pulse Hight Map", 128, 0.0, 256.0, 128, 0.0, 256.0 );
      fadc.Draw( "colz" );
      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      TDataElement element = segment[ 0 ];
      TUshort* data = element.GetUnsignedShortData();
      //Tint nprimitives = element.GetNumberOfPrimitives();
      for ( Tint x = 0; x < 256; x ++ ) {
        for ( Tint y = 0; y < 256; y ++ ) {
          fadc.Fill( x, y, (Tdouble)( *data ) );
          data ++;
        }
      }

      canvas.Modified();
      canvas.Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApplication -> Run();

  return( 0 );
}
