// =====================================================================
//  $Id: St00SinglePixel.hh,v 1.2 2003/07/30 16:15:52 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: St00SinglePixel.hh,v $
//  Revision 1.2  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST0001SINGLEPIEL_HH
#define __ST0001SINGLEPIEL_HH

#include "Tglobals.h"

class St00SinglePixel
{

  protected:
    Tint theHorizontalID;
    Tint theVerticalID;
    Tdouble theSignal;
    Tdouble theDark;
    Tdouble theRms;

  public:
    St00SinglePixel( Tint h = 0, Tint v = 0, Tdouble signal = 0.0, Tdouble dark = 0.0, Tdouble rms = 0.0 );
    St00SinglePixel( const St00SinglePixel& right );
    ~St00SinglePixel();

  public:
    const St00SinglePixel& operator=( const St00SinglePixel& right );
    Tbool operator==( const St00SinglePixel& right ) const;
    Tbool operator!=( const St00SinglePixel& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const St00SinglePixel& right );
    friend Tistream& operator>>( Tistream& tis, St00SinglePixel& right );

  public:
    Tint GetHorizontalID() const;
    Tint GetVerticalID() const;
    Tdouble GetSignal() const;
    Tdouble GetDark() const;
    Tdouble GetRms() const;
    Tvoid SetHorizontalID( Tint id );
    Tvoid SetVerticalID( Tint id );
    Tvoid SetSignal( Tdouble signal );
    Tvoid SetDark( Tdouble dark );
    Tvoid SetRms( Tdouble rms );

};

inline Tint St00SinglePixel::GetHorizontalID() const
{
  return( theHorizontalID );
}

inline Tint St00SinglePixel::GetVerticalID() const
{
  return( theVerticalID );
}

inline Tdouble St00SinglePixel::GetSignal() const
{
  return( theSignal );
}

inline Tdouble St00SinglePixel::GetDark() const
{
  return( theDark );
}

inline Tdouble St00SinglePixel::GetRms() const
{
  return( theRms );
}

inline Tvoid St00SinglePixel::SetHorizontalID( Tint id )
{
  theHorizontalID = id;
  return;
}

inline Tvoid St00SinglePixel::SetVerticalID( Tint id )
{
  theVerticalID = id;
  return;
}

inline Tvoid St00SinglePixel::SetSignal( Tdouble signal )
{
  theSignal = signal;
  return;
}

inline Tvoid St00SinglePixel::SetDark( Tdouble dark )
{
  theDark = dark;
  return;
}

inline Tvoid St00SinglePixel::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

#endif
