// =====================================================================
//  $Id: St00SinglePixelInterface.hh,v 1.2 2003/07/30 16:15:52 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: St00SinglePixelInterface.hh,v $
//  Revision 1.2  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST0001SINGLEPIXELINTERFACE_HH
#define __ST0001SINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "St00SinglePixelList.hh"
#include "TDataMultiplicity.hh"

class St00BadChannelMap;

class St00SinglePixelInterface
{

  private:
    St00SinglePixelList theSinglePixelList;
    St00BadChannelMap* theBadChannelMap;

  public:
    St00SinglePixelInterface( const Tstring& filename );
    St00SinglePixelInterface( const Tstring& dark, const Tstring& source );
    ~St00SinglePixelInterface();

  public:
    const St00SinglePixelList& GetSinglePixelList() const;
    St00SinglePixelList& GetSinglePixelList();
    St00BadChannelMap* GetBadChannelMap() const;

  private:
    Tbool isThisOverThreshold( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThisSinglePixel( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereOverThresholdAroundHere( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereBadChannelAroundHere( Tint row, Tint col ) const;
    Tbool isThisBadChannel( Tint row, Tint col ) const;

};

inline const St00SinglePixelList& St00SinglePixelInterface::GetSinglePixelList() const
{
  return( theSinglePixelList );
}

inline St00SinglePixelList& St00SinglePixelInterface::GetSinglePixelList()
{
  return( theSinglePixelList );
}

inline St00BadChannelMap* St00SinglePixelInterface::GetBadChannelMap() const
{
  return( theBadChannelMap );
}

#endif
