// =====================================================================
//  $Id: St01DarkDataSet.hh,v 1.2 2003/07/30 16:16:10 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: St01DarkDataSet.hh,v $
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01DARKDATASET_HH
#define __ST01DARKDATASET_HH

#include "Tglobals.h"

class St01DarkDataSet
{

  private:
    Tdouble theTemperature;
    Tdouble theCycle;
    Tdouble theVoltage;
    Tdouble theAverage;
    Tdouble theRms;
    // ====
    //  RMSη׻˻Ȥäԥ
    //  theRms/sqrt( theNumberOfData ) Υ顼Ȥʤ
    Tdouble theNumberOfData;
    // ====
    Tint theNumberOfBadChannels;
    Tstring theFileName;

  public:
    St01DarkDataSet( Tdouble temp = 0.0, Tdouble cycle = 0.0, Tdouble v = 0.0, Tdouble ave = 0.0, Tdouble rms = 0.0, Tdouble ndata = 0.0, Tint nbad = 0, const Tstring& file = "" );
    St01DarkDataSet( const St01DarkDataSet& right );
    ~St01DarkDataSet();

  public:
    const St01DarkDataSet& operator=( const St01DarkDataSet& right );
    friend Tostream& operator<<( Tostream& tos, const St01DarkDataSet& right );
    friend Tistream& operator>>( Tistream& tis, St01DarkDataSet& right );

  public:
    Tdouble GetTemperature() const;
    Tdouble GetCycle() const;
    Tdouble GetVoltage() const;
    Tdouble GetAverage() const;
    Tdouble GetRms() const;
    Tdouble GetNumberOfData() const;
    Tint GetNumberOfBadChannels() const;
    const Tstring& GetFileName() const;
    Tvoid SetTemperature( Tdouble temp );
    Tvoid SetCycle( Tdouble cycle );
    Tvoid SetVoltage( Tdouble v );
    Tvoid SetAverage( Tdouble ave );
    Tvoid SetRms( Tdouble rms );
    Tvoid SetNumberOfData( Tdouble ndata );
    Tvoid SetNumberOfBadChannels( Tint nbad );
    Tvoid SetFileName( const Tstring& file );

};

inline Tdouble St01DarkDataSet::GetTemperature() const
{
  return( theTemperature );
}

inline Tdouble St01DarkDataSet::GetCycle() const
{
  return( theCycle );
}

inline Tdouble St01DarkDataSet::GetVoltage() const
{
  return( theVoltage );
}

inline Tdouble St01DarkDataSet::GetAverage() const
{
  return( theAverage );
}

inline Tdouble St01DarkDataSet::GetRms() const
{
  return( theRms );
}

inline Tdouble St01DarkDataSet::GetNumberOfData() const
{
  return( theNumberOfData );
}

inline Tint St01DarkDataSet::GetNumberOfBadChannels() const
{
  return( theNumberOfBadChannels );
}

inline const Tstring& St01DarkDataSet::GetFileName() const
{
  return( theFileName );
}

inline Tvoid St01DarkDataSet::SetTemperature( Tdouble temp )
{
  theTemperature = temp;
  return;
}

inline Tvoid St01DarkDataSet::SetCycle( Tdouble cycle )
{
  theCycle = cycle;
  return;
}

inline Tvoid St01DarkDataSet::SetVoltage( Tdouble v )
{
  theVoltage = v;
  return;
}

inline Tvoid St01DarkDataSet::SetAverage( Tdouble ave )
{
  theAverage = ave;
  return;
}

inline Tvoid St01DarkDataSet::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

inline Tvoid St01DarkDataSet::SetNumberOfData( Tdouble ndata )
{
  theNumberOfData = ndata;
  return;
}

inline Tvoid St01DarkDataSet::SetNumberOfBadChannels( Tint nbad )
{
  theNumberOfBadChannels = nbad;
  return;
}

inline Tvoid St01DarkDataSet::SetFileName( const Tstring& file )
{
  theFileName = file;
  return;
}

#endif
