// =====================================================================
//  $Id: st01.cc,v 1.2 2003/07/30 16:16:12 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: st01.cc,v $
//  Revision 1.2  2003/07/30 16:16:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "St01RunAction.hh"
#include "St01EventAction.hh"
#include "St01CrateDefinition.hh"
#include "St01ReadoutBookDefinition.hh"
#include "St01DarkViewCommand.hh"
#include "St01SignalViewCommand.hh"

static const Tstring _rcpath = "st01setup";

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> GetEventManager() -> SetStackSize( 0 );

  manager -> GetEnvironmentVariableTable().SetEnvironment( _rcpath );
  manager -> SetRunAction( new St01RunAction() );
  manager -> SetEventAction( new St01EventAction() );
  manager -> SetCrateDefinition( new St01CrateDefinition() );
  manager -> SetReadoutBookDefinition( new St01ReadoutBookDefinition() );

  manager -> SetUserCommand( new St01DarkViewCommand() );
  manager -> SetUserCommand( new St01SignalViewCommand() );

  manager -> SessionStart();

  delete manager;

  return( 0 );
}
