// =====================================================================
//  $Id: st02OFFsubplot.cc,v 1.1 2003/09/09 22:19:49 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: st02OFFsubplot.cc,v $
//  Revision 1.1  2003/09/09 22:19:49  goiwai
//  ޤ,OFFxxx.ccȤե̾äե饤ѤΥץ
//  st02OFFxxx.ccѹޤ.
//  ե̾ɻߤŪǤ.
//
//  Revision 1.2  2003/07/30 16:16:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St02DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "subtracted H.O.C", 500, -1000.0, 4096.0 );
  //mpx201a.SetFillColor( 45 );


  St02DataRecordConversion conversion;
  TDataRecord r;
  Tstring ifname = argv[ 1 ];
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> r ) != 0 ) {
    TDataMultiplicity& map = conversion.Convert( r );
    if ( conversion.IsSuccess() ) {
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  mpx201a.Fill( map[ row ][ col ] );
	} 
      }
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return( 0 );
}
