// =====================================================================
//  $Id: Trootinit.h,v 1.4 2003/07/30 16:17:11 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: Trootinit.h,v $
//  Revision 1.4  2003/07/30 16:17:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TROOTINIT_H
#define __TROOTINIT_H
//#ifdef __CLDAQ_ROOT_USE

#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TGraphErrors.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>
#include <TF1.h>
#include <TLegend.h>
#include <TPaveText.h>
#include <TRandom.h>
#include <TStopwatch.h>
#include <TGaxis.h>
#include <TLatex.h>
#include <TPaveStats.h>

#include "Tglobals.h"

inline static TApplication* rootinit( const Tstring& name = "ROOTANALYSER", Tint* argc = 0, Tchar** argv = 0 )
{
  TApplication* app = new TApplication( name.c_str(), argc, argv );
  gROOT -> Reset( 0 );

  // ===================================================================
  const Float_t padmargint = 0.12;
  const Float_t padmarginb = 0.12;
  const Float_t padmarginr = 0.04;
  const Float_t padmarginl = 0.12;
  //const Color_t histfillcolor = 21;
  const Int_t optstat = 1111110;
  const Int_t optfit = 1111;
  const Int_t transparence = 10;
  //const Int_t titlecolor = transparence;
  const Float_t titlew = 1.0 - padmarginl - padmarginr;
  const Float_t titleh = padmargint / 2.0;
  const Float_t titlex = padmarginl;
  const Float_t titley = 1.0 - titleh + padmargint / 10.0;

  const Int_t statcolor = transparence;
  const Float_t statx = 1.0 - padmarginr;
  const Float_t statw = 0.32;
  const Float_t staty = 1.0 - padmargint;
  const Int_t framefillcolor = transparence;
  const Int_t canvascolor = transparence;
  //const Float_t datex = 0.88;
  //const Float_t datey = 0.91;
  //const Int_t maxdigits = 6;

  const Style_t markerstyle = 21;
  //const Color_t markercolor = 2;
  //const Size_t markersize = 1;
  //const Color_t funccolor = 4;
  //const Style_t funcstyle = 1;
  //const Width_t funcwidth = 5;
  // ===================================================================



  // Pad
  gStyle -> SetPadTickX( kTRUE );
  gStyle -> SetPadTickY( kTRUE );
  //gStyle -> SetPadGridX( kTRUE );
  //gStyle -> SetPadGridY( kTRUE );
  gStyle -> SetPadBorderSize( 0 );
  gStyle -> SetPadBorderMode( 0 );
  gStyle -> SetPadTopMargin( padmargint );
  gStyle -> SetPadBottomMargin( padmarginb );
  gStyle -> SetPadRightMargin( padmarginr );
  gStyle -> SetPadLeftMargin( padmarginl );



  // Status
  gStyle -> SetStatBorderSize( 1 );
  gStyle -> SetStatColor( statcolor );
  gStyle -> SetStatStyle( 0 );
  gStyle -> SetStatX( statx );
  gStyle -> SetStatW( statw );
  gStyle -> SetStatY( staty );


  // Frame
  //gStyle -> SetFrameFillColor( 21 );
  //gStyle -> SetFrameFillColor( 3 );
  //gStyle -> SetFrameFillStyle( 1001 );
  gStyle -> SetFrameBorderMode( 0 );
  gStyle -> SetFrameBorderSize( 0 );
  gStyle -> SetFrameFillColor( framefillcolor );
  gStyle -> SetFrameFillStyle( 0 );



  // Canvas
  gStyle -> SetCanvasBorderMode( 0 );
  gStyle -> SetCanvasBorderSize( 0 );
  gStyle -> SetCanvasColor( canvascolor );



  // Histogram
  //gStyle -> SetHistFillColor( transparence );

  // Marker
  gStyle -> SetMarkerStyle( markerstyle );
  //gStyle -> SetMarkerColor( markercolor );
  //gStyle -> SetMarkerSize( markersize );


  // Function
  //gStyle -> SetFuncColor( funccolor );
  //gStyle -> SetFuncStyle( funcstyle );
  //gStyle -> SetFuncWidth( funcwidth );





  // Option
  gStyle -> SetOptStat( optstat );
  gStyle -> SetOptFit( optfit );


  // title
  gStyle -> SetTitleBorderSize( 0 );
  gStyle -> SetTitleStyle( 0 );
  gStyle -> SetTitleX( titlex );
  gStyle -> SetTitleY( titley );
  gStyle -> SetTitleW( titlew );
  gStyle -> SetTitleH( titleh );



  //  TGaxis *axis;
  //  Int_t kCenterTitle = 1<<12;
  //TGaxis::SetMaxDigits( maxdigits );
  gStyle -> SetPaperSize( TStyle::kA4 );


  // Date
  //gStyle -> SetOptDate( 3 );
  //gStyle -> SetDateX( datex );
  //gStyle -> SetDateY( datey );

  // Palette
  gStyle -> SetPalette( 1 );

  return( app );
}

//#endif
#endif
