// =====================================================================
//  $Id: TDataSegment.hh,v 1.3 2003/08/25 09:21:44 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TDataSegment.hh,v $
//  Revision 1.3  2003/08/25 09:21:44  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  segment[0] Ȥ segment["tag"] Ȥ, TDataElement 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataElement ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TDATASEGMENT_HH
#define __TDATASEGMENT_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataElementList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSegment
  : public TStreamableObject, public TDataElementList
{

  public:
    TDataSegment( const Tstring& id = TunknownID );
    TDataSegment( const TDataSegment& right );
    ~TDataSegment();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* output );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataSegment& operator=( const TDataSegment& right );
    Tbool operator==( const TDataSegment& right ) const;
    Tbool operator!=( const TDataSegment& right ) const;
    const TDataElement& operator[]( Tint n ) const;
    TDataElement& operator[]( Tint n );
    const TDataElement& operator[]( const Tstring& id ) const;
    TDataElement& operator[]( const Tstring& id );
    friend Tostream& operator<<( Tostream& tos, const TDataSegment& right );

  public:
    Tbool FindDataElement( const Tstring& id, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& id ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );


};

#endif
