// =====================================================================
//  $Id: findfast.cc,v 1.2 2003/07/30 16:21:38 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: findfast.cc,v $
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );

  TDataRecord record;

  TBenchmark bench;
  bench.Start();
  Tint nelements = 0;
  while ( ( ifile.Read( record ) ) != 0 ) {
    //fast access section 0, segment 0, element 1.
    Tcout << record[0][0][1] << Tendl;
    nelements ++;
  }
  Tcout << nelements << " element(s) have been found out from ";
  Tcout << filename << "." << Tendl;
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
