// =====================================================================
//  $Id: St01ReadoutBookDefinition.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: St01ReadoutBookDefinition.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "St01ReadoutBookDefinition.hh"

St01ReadoutBookDefinition::St01ReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

St01ReadoutBookDefinition::~St01ReadoutBookDefinition()
{;}

TReadoutBook* St01ReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();


  // set segement from crate
  TReadoutSegment runid( theCrate -> GetModule( "runid" ), "RUN ID" );
  TReadoutSegment runinfo( theCrate -> GetModule( "runinfo" ), "RUN INFO" );
  TReadoutSegment clock( theCrate -> GetModule( "clock" ), "CLOCK" );
  TReadoutSegment timer( theCrate -> GetModule( "timer" ), "TIMER" );
  TReadoutSegment eventid( theCrate -> GetModule( "evtid" ), "EVENT ID" );
  TReadoutSegment fadc( theCrate -> GetModule( "daughter" ), "ADC" );
  TReadoutSegment sm( theCrate -> GetModule( "source meter" ), "KEITHLEY" );


  // define readout at run begin
  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "INFO" );
  sec0.push_back( runid );
  sec0.push_back( runinfo );
  sec0.push_back( clock );
  sec0.push_back( timer );
  runbegin -> push_back( sec0 );



  // define readout at end record
  TReadoutList* runend = new TReadoutList( "RUN END" );
  TReadoutSection sec1( "INFO" );
  sec1.push_back( runinfo );
  sec1.push_back( clock );
  sec1.push_back( timer );
  runend -> push_back( sec1 );



  // define event record
  TReadoutList* event = new TReadoutList( "EVENT" );
  TReadoutSection sec2( "INFO" );
  sec2.push_back( eventid );
  sec2.push_back( clock );
  sec2.push_back( timer );
  TReadoutSection sec3( "EVENT" );
  sec3.push_back( fadc );
  sec3.push_back( sm );
  event -> push_back( sec2 );
  event -> push_back( sec3 );



  // define book
  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( event );



  return book;
}
