// =====================================================================
/*!
//
//  \file TAnalysisStatusTable.hh
//  \brief This file contains the TAnalysisStatusTable class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TAnalysisStatusTable.hh,v 1.4 2003/11/03 08:35:10 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TAnalysisStatusTable.hh,v $
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TANALYSISSTATUSTABLE_HH
#define __TANALYSISSTATUSTABLE_HH

#include "Tglobals.h"
#include "TAnalysisStatus.hh"

typedef Tvector<TAnalysisStatus> TAnalysisStatusList;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TAnalysisStatusTable
// \brief This is the TAnalysisStatusTable class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TAnalysisStatusTable class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TAnalysisStatusTable
  : TAnalysisStatusList
{

  public:
    enum { tNotFound = -1 };

  public:
    TAnalysisStatusTable();
    ~TAnalysisStatusTable();

  public:
    friend Tostream& operator<<( Tostream& tos, const TAnalysisStatusTable& right );

  public:
    Tvoid AddAnalysisStatus( const TAnalysisStatus& status );
    Tvoid RemoveAnalysisStatus( const Tstring& id );
    Tint FindAnalysisStatus( const Tstring& id ) const;
    Tvoid Clear();
    Tstatus_t GetStatus( const Tstring& id ) const;
    Tvoid SetStatus( const Tstring& id, Tstatus_t status );
    Tobject_t GetObjectType( const Tstring& id ) const;
    Tstring GetID( const Tstring& id ) const;
    Tstring GetDrawableObjectID( const Tstring& id ) const;
    Tstring GetCanvasID( const Tstring& id ) const;
    Tthread_t* GetThreadID( const Tstring& id );
    Tvoid SetThreadID( const Tstring& id, Tthread_t thread );
    Tbool HasStatus( const Tstring& id ) const;

};

#endif
