// =====================================================================
/*!
//
//  \file TCommand.hh
//  \brief This file contains the TCommand class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCommand.hh,v 1.4 2003/11/03 08:35:11 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TCommand.hh,v $
//  Revision 1.4  2003/11/03 08:35:11  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TCOMMAND_HH
#define __TCOMMAND_HH

#include "Tglobals.h"

class TRunManager;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCommand
// \brief This is the TCommand class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCommand class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup CommandsCategory
*/
class TCommand
{

  protected:
    TRunManager* theRunManager;
    Tstring theCommandName;
    Tstring theGuidance;

  public:
    TCommand( TRunManager* manager, const Tstring& name, const Tstring& guidance = "" );
    TCommand( const Tstring& name, const Tstring& guidance = "" );
    virtual ~TCommand();

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );
    const Tstring& GetCommandName() const;
    const Tstring& GetGuidance() const;
    Tvoid SetCommandName( const Tstring& name );
    Tvoid SetGuidance( const Tstring& guidance );

  public:
    virtual Tvoid Execute( const TstringList& arguments );
    virtual Tvoid ShowCommandDetail() const;

};

inline const Tstring& TCommand::GetCommandName() const
{
  return theCommandName;
}

inline const Tstring& TCommand::GetGuidance() const
{
  return theGuidance;
}

inline Tvoid TCommand::SetCommandName( const Tstring& name )
{
  theCommandName = name;
  return;
}

inline Tvoid TCommand::SetGuidance( const Tstring& guidance )
{
  theGuidance = guidance;
  return;
}

inline TRunManager* TCommand::GetRunManager() const
{
  return theRunManager;
}

inline Tvoid TCommand::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

#endif
