// =====================================================================
/*!
//
//  \file TRs232cModule.hh
//  \brief This file contains the TRs232cModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TRs232cModule.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TRs232cModule.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TRS232CMODULE_HH
#define __TRS232CMODULE_HH

#include "Tglobals.h"
#include "TModule.hh"

class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TRs232cModule
// \brief This is the TRs232cModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TRs232cModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TRs232cModule
  : public TModule
{

  protected:
    Tint theFileDescriptor;
    Tstring theDeviceFile;
    struct termio theSerialPort;

  public:
    TRs232cModule( const Tstring devfile = "/dev/ttyS0", Tint nchannel = 1 );
    TRs232cModule( Tint nchannel, Tstring devfile = "/dev/ttyS0" );
    TRs232cModule( const TRs232cModule& right );

  protected:
    virtual ~TRs232cModule();

  public:
    virtual const TRs232cModule& operator=( const TRs232cModule& right );
    virtual Tbool operator==( const TRs232cModule& right ) const;
    virtual Tbool operator!=( const TRs232cModule& right ) const;

  public:
    virtual Tint Clear();
    virtual Tint Update();
    virtual Tint Initialize();
    virtual Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tvoid DoClearMethod( Tint channel );
    Tvoid DoUpdateMethod( Tint channel );
    Tvoid DoInitializeMethod( Tint channel );
    Tstring DoReadMethod( Tint channel );

  protected:
    virtual Tvoid defineClearMethod( Tint channel ) = 0;
    virtual Tvoid defineUpdateMethod( Tint channel ) = 0;
    virtual Tvoid defineInitializeMethod( Tint channel ) = 0;
    virtual Tvoid defineReadMethod( Tint channel ) = 0;
    virtual Tbool modifyData( const Tstring& accept, Tdouble& databuf ) const;

  public:
    Tint Open();
    Tstring Read();
    Tint Write( const Tstring& token );
    Tint Close();

  public:
    Tbool IsOpen() const;
    Tint GetFileDescriptor() const;
    const Tstring& GetDeviceFile() const;
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetDeviceFile( const Tstring& devfile );
    const struct termio& GetSerialPort() const;
    struct termio& GetSerialPort();
    Tvoid SetSerialPort( const struct termio& serial );

};

inline Tbool TRs232cModule::IsOpen() const
{
  if ( theFileDescriptor != -1 ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

inline Tint TRs232cModule::GetFileDescriptor() const
{
  return theFileDescriptor;
}

inline const Tstring& TRs232cModule::GetDeviceFile() const
{
  return theDeviceFile;
}

inline Tvoid TRs232cModule::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TRs232cModule::SetDeviceFile( const Tstring& devfile )
{
  theDeviceFile = devfile;
  return;
}

inline const struct termio& TRs232cModule::GetSerialPort() const
{
  return theSerialPort;
}

inline struct termio& TRs232cModule::GetSerialPort()
{
  return theSerialPort;
}

inline Tvoid TRs232cModule::SetSerialPort( const struct termio& serial )
{
  theSerialPort = serial;
  return;
}

inline Tvoid TRs232cModule::DoClearMethod( Tint channel )
{
  defineClearMethod( channel );
  return;
}

inline Tvoid TRs232cModule::DoUpdateMethod( Tint channel )
{
  defineUpdateMethod( channel );
  return;
}

inline Tvoid TRs232cModule::DoInitializeMethod( Tint channel )
{
  defineInitializeMethod( channel );
  return;
}

inline Tstring TRs232cModule::DoReadMethod( Tint channel )
{
  defineReadMethod( channel );
  return Read();
}

inline Tbool TRs232cModule::modifyData( const Tstring& accept, Tdouble& databuf ) const
{
  return Tfalse;
}

#endif
