// =====================================================================
//  $Id: Rs01RunAction.cc,v 1.4 2003/10/18 15:58:50 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: Rs01RunAction.cc,v $
//  Revision 1.4  2003/10/18 15:58:50  goiwai
//  ⥸塼ʳκǽ˽褦ˤޤ.
//
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRun.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TOutputObjectFile.hh"
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs01RunAction.hh"
#include "Rs01RunSummary.hh"

Rs01RunAction::Rs01RunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

Rs01RunAction::~Rs01RunAction()
{;}

Tvoid Rs01RunAction::BeginOfRunAction( TRun& aRun )
{
  Tstring drecfile;
  Tstring htmlfile;
  setFileName( aRun.GetRunID(), drecfile, htmlfile );

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "initialize at begin of run" );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  theOutputFile -> Write( record );

  theOutputHtml.Open( htmlfile );
  Tcout << "run summary outputs into " << htmlfile << Tendl;
  theRunSummary = new Rs01RunSummary();
  fillRunBeginInformation( record );

  return;
}

Tvoid Rs01RunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  theOutputFile -> Write( record );

  fillRunEndInformation( record );
  Tstring title = "Run Summary #" + (theRunManager->GetRun()).GetStringRunID();
  theOutputHtml.SetTitle( title );
  theOutputHtml << theRunSummary -> GenerateRunSummaryTable() << Tendl;
  theOutputHtml.Close();


  Tstring htmlfile = theOutputHtml.GetFileName();
  const TEnvironmentVariableTable& envtable =
    theRunManager -> GetEnvironmentVariableTable();
  Tbool autoprint = (Tbool)envtable.GetIntegerValue( "RS01_AUTO_PRINT" );
  if ( autoprint ) {
    Tstring html2ps = envtable.GetEnvironmentValue( "RS01_HTML2PS" );
    Tstring command = html2ps + " " + htmlfile + " | lpr";
    system( command.c_str() );
  }

  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;

  return;
}

Tvoid Rs01RunAction::setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile )
{

  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";


  const TEnvironmentVariableTable& envtable =
    theRunManager -> GetEnvironmentVariableTable();

  Tstring filehead = envtable.GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring drecdir = envtable.GetEnvironmentValue( "RS01_RECORD_DIR" );
  Tstring htmldir = envtable.GetEnvironmentValue( "RS01_SUMMARY_DIR" );
  Tbool overwrite = (Tbool)envtable.GetIntegerValue( "RS01_OVERWRITE_ENABLE" );

  Tstring runidstr = itostr( runid );
  drecfile = drecdir + Tslash + filehead + runidstr + drecext;
  htmlfile = htmldir + Tslash + filehead + runidstr + htmlext;

  if ( overwrite == 0 ) {
    if ( isexist( drecfile ) ) {
      Tcout << "already exist " << drecfile << "." << Tendl;
      drecfile += "." + itostr( theRunManager->GetRunClock().GetLastUpdateTime() );
    }
    if ( isexist( htmlfile ) ) {
      Tcout << "already exist " << htmlfile << "." << Tendl;
      htmlfile += "." + itostr( theRunManager->GetRunClock().GetLastUpdateTime() );
    }
  }

  return;
}

Tvoid Rs01RunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "RUN INFO", "CLOCK", "0" };

  TDataElement clock;
  Tstring strbuf;
  record.FindDataElement( clockset, clock );
  clock.StorePrimitives( &strbuf );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunBeginTime( strbuf );

  return;
}

Tvoid Rs01RunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "RUN INFO", "CLOCK", "0" };
  TDataElement clock;
  Tstring strbuf;
  record.FindDataElement( clockset, clock );
  clock.StorePrimitives( &strbuf );

  const TRunInformationTable& table =
    theRunManager -> GetRunInformationModule() -> GetRunInformationTable();

  theRunSummary -> SetRunID( theRunManager -> GetRun().GetRunID() );
  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( strbuf );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}
