// =====================================================================
/*!
//
//  \file TReadoutList.hh
//  \brief This file contains the TReadoutList class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutList.hh,v 1.5 2004/01/19 21:09:42 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TReadoutList.hh,v $
//  Revision 1.5  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTLIST_HH
#define CLDAQ__TREADOUTLIST_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutSectionList.hh"

class TDataRecord;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutList
// \brief This is the TReadoutList class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutList class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutList
  : public TReadoutIdentification, public TReadoutSectionList
{

  public:
    TReadoutList( const Tstring& id = TunknownID );
    TReadoutList( const TReadoutList& right );
    ~TReadoutList();

  public:
    const TReadoutList& operator=( const TReadoutList& right );
    Tbool operator==( const TReadoutList& right ) const;
    Tbool operator!=( const TReadoutList& right ) const;

  public:
    TDataRecord Read();    

};

#endif
