// =====================================================================
/*!
//
//  \file TRun.hh
//  \brief This file contains the TRun class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TRun.hh,v 1.9 2004/01/19 21:09:43 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TRun.hh,v $
//  Revision 1.9  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.8  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.7  2003/10/06 17:02:45  goiwai
//  *** empty log message ***
//
//  Revision 1.6  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TRUN_HH
#define CLDAQ__TRUN_HH

#include "Tglobals.h"
#include "TEventStack.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TRun
// \brief This is the TRun class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TRun class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup RunCategory
*/
class TRun
{

  private:
    Tint theRunID;
    TEventStack theEventStack;

  public:
    TRun( Tint runid = 0 );
    TRun( const TEventStack& eventstack );
    TRun( Tint runid, const TEventStack& eventstack );
    TRun( const TRun& right );
    virtual ~TRun();

  public:
    const TRun& operator=( const TRun& right );
    Tbool operator==( const TRun& right ) const;
    Tbool operator!=( const TRun& right ) const;

  public:
    Tint GetRunID() const;
    Tvoid SetRunID( Tint runid );
    const TEventStack& GetEventStack() const;
    TEventStack& GetEventStack();
    Tvoid SetEventStack( const TEventStack& eventstack );

  public:
    virtual Tvoid Clear();
    virtual Tstring GetStringRunID( Tint digits = 6 ) const;

};

inline Tint TRun::GetRunID() const
{
  return theRunID;
}
inline const TEventStack& TRun::GetEventStack() const
{
  return theEventStack;
}

inline TEventStack& TRun::GetEventStack()
{
  return theEventStack;
}

inline Tvoid TRun::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid TRun::SetEventStack( const TEventStack& eventstack )
{
  theEventStack = eventstack;
  return;
}

#endif
