// ============================================================================
//  $Id: TOptionMap.cc,v 1.1 2003/10/06 16:32:25 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TOptionMap.cc,v $
//  Revision 1.1  2003/10/06 16:32:25  goiwai
//  GNUΰñˤľŪ˲᤹뤿ʤǤ.
//
// ============================================================================
#include "TOptionMap.hh"

TOptionMap::TOptionMap()
  : theOptionList(),
    theParameterList()
{;}

TOptionMap::TOptionMap( const TOptionMap& right )
  : theOptionList(),
    theParameterList()
{;}

TOptionMap::~TOptionMap()
{;}

const TOptionMap& TOptionMap::operator=( const TOptionMap& right )
{
  theOptionList = right.theOptionList;
  theParameterList = right.theParameterList;
  return *this;
}

Tbool TOptionMap::HasOption( const TOption& option ) const
{
  for ( Tsize_t i = 0; i < theOptionList.size(); i ++ ) {
    if ( theOptionList[ i ] == option ) {
      return Ttrue;
    }
  }
  return Tfalse;
}

Tbool TOptionMap::HasOption( const Tstring& option ) const
{
  for ( Tsize_t i = 0; i < theOptionList.size(); i ++ ) {
    if ( theOptionList[ i ] == option ) {
      return Ttrue;
    }
  }
  return Tfalse;
}

Tvoid TOptionMap::AddOption( const TOption& option, const Tstring& param )
{
  // ʣᤤԾ
  if ( !HasOption( option ) ) {
    theOptionList.push_back( option );
    theParameterList.push_back( param );
  }
  return;
}

Tstring TOptionMap::GetParameter( Tint index ) const
{
  Tstring retval = "";
  Tint listlen = (Tint)theParameterList.size();
  if ( index >= 0 && index < listlen && !theParameterList.empty() ) {
    retval = theParameterList[ index ];
  }
  return retval;
}

Tstring TOptionMap::GetParameter( const Tstring& optionname ) const
{
  Tstring retval = "";
  for ( Tsize_t i = 0; i < theOptionList.size(); i ++ ) {
    if ( theOptionList[ i ] == optionname ) {
      retval = theParameterList[ i ];
      break;
    }
  }
  return retval;
}

Tstring TOptionMap::GetParameter( const TOption& option ) const
{
  Tstring retval = "";
  for ( Tsize_t i = 0; i < theOptionList.size(); i ++ ) {
    if ( theOptionList[ i ] == option ) {
      retval = theParameterList[ i ];
      break;
    }
  }
  return retval;
}

Tostream& operator<<( Tostream& tos, const TOptionMap& right )
{
  for ( Tsize_t i = 0; i < right.theOptionList.size(); i ++ ) {  
    tos << "-" << right.theOptionList[ i ].GetShortOption();
    tos << ", --" << right.theOptionList[ i ].GetLongOption();
    if ( ! right.theParameterList[ i ].empty() ) {
      tos << ": \"" << right.theParameterList[ i ] << "\"";
    }
    if ( i != right.theOptionList.size() - 1 ) {
      tos << Tendl;
    }
  }
  tos << Tflush;
  return tos;
}
