// =====================================================================
//  $Id: St00CrateDefinition.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: St00CrateDefinition.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TEnvironmentVariableTable.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "TRunManager.hh"
#include "St00CrateDefinition.hh"

St00CrateDefinition::St00CrateDefinition()
  : TCrateDefinition()
{;}

St00CrateDefinition::~St00CrateDefinition()
{;}

TCrate* St00CrateDefinition::Define()
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "SOURCE RUN" );
  selectlist.push_back( "DARK RUN" );
  selectlist.push_back( "TEST RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  infolist.push_back( TRunInformation( "DEVICE ID", tInfoFreeValue ) );
  selectlist.clear();
  selectlist.push_back( "-120.0" );
  selectlist.push_back( "-110.0" );
  selectlist.push_back( "-100.0" );
  selectlist.push_back( "-90.0" );
  selectlist.push_back( "-80.0" );
  selectlist.push_back( "-70.0" );
  selectlist.push_back( "-60.0" );
  selectlist.push_back( "-50.0" );
  selectlist.push_back( "-40.0" );
  selectlist.push_back( "-30.0" );
  selectlist.push_back( "-20.0" );
  selectlist.push_back( "-10.0" );
  selectlist.push_back( "0.0" );
  selectlist.push_back( "10.0" );
  infolist.push_back( TRunInformation( "TEMPERATURE[C]", selectlist ) );
  infolist.push_back( TRunInformation( "RUN BEGIN RESISTANCE[ohm]", tInfoFreeValue ) );
  infolist.push_back( TRunInformation( "RUN END RESISTANCE[ohm]", tInfoFreeValue ) );
  infolist.push_back( TRunInformation( "RUN BEGIN PRESSURE[Pa]", tInfoFreeValue ) );
  infolist.push_back( TRunInformation( "RUN END PRESSURE[Pa]", tInfoFreeValue ) );
  selectlist.clear();
  selectlist.push_back( "2.0" );
  selectlist.push_back( "4.0" );
  selectlist.push_back( "6.0" );
  selectlist.push_back( "8.0" );
  selectlist.push_back( "10.0" );
  selectlist.push_back( "12.0" );
  selectlist.push_back( "14.0" );
  selectlist.push_back( "16.0" );
  infolist.push_back( TRunInformation( "PERIOD[sec]", selectlist ) );
  selectlist.clear();
  selectlist.push_back( "4.0" );
  selectlist.push_back( "5.0" );
  selectlist.push_back( "6.0" );
  selectlist.push_back( "6.2" );
  selectlist.push_back( "6.3" );
  selectlist.push_back( "6.4" );
  selectlist.push_back( "6.6" );
  selectlist.push_back( "6.8" );
  selectlist.push_back( "7.0" );
  selectlist.push_back( "7.2" );
  selectlist.push_back( "7.4" );
  selectlist.push_back( "7.6" );
  selectlist.push_back( "7.8" );
  selectlist.push_back( "8.0" );
  selectlist.push_back( "9.0" );
  selectlist.push_back( "10.0" );
  selectlist.push_back( "12.0" );
  infolist.push_back( TRunInformation( "NEGATIVE VOLTAGE[V]", selectlist ) );
  infolist.push_back( TRunInformation( "OTHER CONDITION", tInfoFreeText ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable runinfotable( infolist );


  TCrate* crate = new TCrate();
  TstringList groups;

  // VME module
  const TEnvironmentVariableTable& envtable = 
    TRunManager::GetRunManager() -> GetEnvironmentVariableTable();

  Tint mpxoffset = envtable.GetIntegerValue( "ST00_MPX201A_OFFSET" );
  Tint samplerate = envtable.GetIntegerValue( "ST00_MPX201A_SAMPLING" );
  Tint nblock = envtable.GetIntegerValue( "ST00_MPX201A_BLOCK" );
  Tint memoffset = envtable.GetIntegerValue( "ST00_MPX201A_DAUGHTER" );
  Tint rpvoffset = envtable.GetIntegerValue( "ST00_RPV130_OFFSET" );

  TVmeMpx201aModule* mpx201a = new TVmeMpx201aModule( mpxoffset );
  mpx201a -> SetupCCDmeasurement( samplerate, nblock, memoffset );
  TVmeDaughterBoardMemoryModule* daughter
    = new TVmeDaughterBoardMemoryModule( mpx201a );
  TVmeRpv130Module* rpv130 = new TVmeRpv130Module( rpvoffset );

  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "event" );
  crate -> InstallModule( mpx201a, "mpx201a", groups );
  crate -> InstallModule( daughter, "daughter", groups );
  crate -> InstallModule( rpv130, "rpv130", groups );


  // software module
  TSoftwareRunInformationModule* runinfo
    = new TSoftwareRunInformationModule( runinfotable );
  crate -> InstallModule( runinfo, "runinfo" );
  TRunManager::GetRunManager() -> SetRunInformationModule( runinfo );

  TSoftwareClockModule* clock = new TSoftwareClockModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( clock, "clock", groups );

  TSoftwareScalerModule* runid = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( runid, "runid", groups );

  TSoftwareScalerModule* evtid = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "event" );
  crate -> InstallModule( evtid, "evtid", groups );

  return crate;
}
