// =====================================================================
//  $Id: TRunTimeLimitCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TRunTimeLimitCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunTimeLimitCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "/run/timelimit";
static const Tstring _desc = "set time limit in second for a run scheduling.\nexample> /run/timelimit 3600 // an hour.";

TRunTimeLimitCommand::TRunTimeLimitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunTimeLimitCommand::~TRunTimeLimitCommand()
{;}

Tvoid TRunTimeLimitCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TRunTimeLimitCommand::Execute: ";
  TUserInterface* ui = theRunManager -> GetUserInterface();

  if ( arguments.empty() ) {
    TUint rest = alarm( alarm( 0 ) );
    if ( rest == 0 ) {
      Tcout << "this run is not scheduled by alarm." << Tendl;
    } else {
      ui -> ExecuteCommand( "/system/date" );
      Tcout << "this run is scheduled to stop after " << rest << " seconds." << Tendl;
    }
  } else if ( arguments.size() == 1 ) {
    TUint timesec = strtoul( arguments[ 0 ].c_str(), 0, 0 );
    TUint ret = alarm( timesec );
    if ( ret != 0 ) {
      ui -> ExecuteCommand( "/system/date" );
      Tcout << "this run was re-scheduled to stop after " << timesec << " seconds." << Tendl;
      Tcout << "last schedule is " << ret << " seconds, was removed." << Tendl;
    } else {
      Tcout << "this run was scheduled to stop after " << timesec << " seconds." << Tendl;
    }
  } else {
    ShowCommandDetail();
  }

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRunTimeLimitCommand)
#endif
