// =====================================================================
/*!
//
//  \file TInputObjectSharedMemory.hh
//  \brief This file contains the TInputObjectSharedMemory class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectSharedMemory.hh,v 1.7 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TInputObjectSharedMemory.hh,v $
//  Revision 1.7  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TINPUTOBJECTSHAREDMEMORY_HH
#define CLDAQ__TINPUTOBJECTSHAREDMEMORY_HH

#include "Tglobals.h"
#include "TObjectSharedMemory.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TInputObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectSharedMemory
// \brief This is the TInputObjectSharedMemory class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectSharedMemory class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectSharedMemory
  : public TObjectSharedMemory, public TInputObjectStream
{

  private:
    Tbool theReadSuccessFlag;

  public:
    TInputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TInputObjectSharedMemory( TInputObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TInputObjectSharedMemory();

  public:
    Tint Read( TStreamableObject& object );

  public:
    Tbool IsReadSuccess() const;

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );
#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TInputObjectSharedMemory,0)
#endif

};

inline Tbool TInputObjectSharedMemory::IsReadSuccess() const
{
  return theReadSuccessFlag;
}

#endif
