// =====================================================================
//  $Id: ofilez.cc,v 1.1 2003/12/23 18:48:18 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: ofilez.cc,v $
//  Revision 1.1  2003/12/23 18:48:18  goiwai
//  TOutputObjectFileZ/TInputObjectFileZ ΥƥȥץǤ.
//  ifilter/ofilterȤäƤ뤳ȤƱ,ɤιԿϾޤ.
//  ⤦ͻҤߤƾŪˤϤǥեȤϤˤ褦Ȼפޤ.
//  쥳ɤ˥ե륿IDĤʤ㤤ʤäʤ..
//
// =====================================================================
#include "TOutputObjectFileZ.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opev( "number-of-events", 1 );
  TOption opof( "output-record-name", 1 );
  const Tint noption = 2;
  TOption options[ noption ] = { opev, opof };
  TArgument arg( argc, argv, TOptionTable( options, noption ) );

  Tint nevent = 10;
  if ( arg.HasOption( opev ) ) {
    nevent = arg.GetIntegerParameter( opev );
  }

  Tstring filename = "ofilez.drec";
  if ( arg.HasOption( opof ) ) {
    filename = arg[ opof ];
  }

  TOutputObjectFileZ ofilez( filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record;
    record.Test( i );
    ofilez.Write( record );
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofilez.GetTotalDataSize();
  Tcout << "(Finalize NOT yet)";
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return 0;
}
