// =====================================================================
//  $Id: ofilter.cc,v 1.1 2003/12/06 11:04:02 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: ofilter.cc,v $
//  Revision 1.1  2003/12/06 11:04:02  goiwai
//  ̥ե륿̤ƥǡ쥳ɤ¸򤷤ޤ.
//
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"
#include "TCompressObjectFilter.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opev( "number-of-events", 1 );
  TOption opof( "output-record-name", 1 );
  const Tint noption = 2;
  TOption options[ noption ] = { opev, opof };
  TArgument arg( argc, argv, TOptionTable( options, noption ) );

  Tint nevent = 10;
  if ( arg.HasOption( opev ) ) {
    nevent = arg.GetIntegerParameter( opev );
  }

  Tstring filename = "ofilter.drec";
  if ( arg.HasOption( opof ) ) {
    filename = arg[ opof ];
  }

  TCompressObjectFilter filter;
  TOutputObjectFile ofile( &filter, filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record;
    record.Test( i );
    ofile.Write( record );
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  /*!
  // FinalizeäƤʤ
  // 󥳡λäƤ륭å夬񤭤ޤʤΤǤ
  // FinalizeϼʬǤʤƤTOutputObjectFile֥ǻ
  // ƤФޤ
  */
  filter.Finalize(&ofile);
  Tcout << "----" << Tendl;
  Tcout << "Finalize done: " << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return 0;
}
