/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.datetime.PatternDateConverter;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Duration;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.TableView;

public class TimeCardMain
extends ClearfySection {
    private Form recordViewForm;
    private Form timeRecorder;
    private AjaxButton update1;
    private AjaxButton update2;
    private TableView tableView;

    public TimeCardMain(String id, ClearfyPage pageClass) {
        super(id, pageClass);
    }

    public void drawContent() {
        this.timeRecorder = new Form("timeRecorder");
        AbstractReadOnlyModel<Date> clockModel = new AbstractReadOnlyModel<Date>(){

            public Date getObject() {
                return new Date();
            }
        };
        this.timeRecorder.add(new Component[]{new DateLabel("clock", (IModel)clockModel, new PatternDateConverter("yyyy/MM/dd HH:mm:ss", true)){

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)1))});
            }
        }});
        this.add(new Component[]{this.timeRecorder});
        this.recordViewForm = new Form("recordViewForm");
        this.update1 = new AjaxButton("update1"){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                TimeCardMain.this.showCurrentRecord();
                target.add(new Component[]{form});
                target.add(new Component[]{TimeCardMain.this.tableView});
            }
        };
        this.recordViewForm.add(new Component[]{this.update1});
        this.update2 = new AjaxButton("update2"){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                TimeCardMain.this.showCurrentRecord();
                target.add(new Component[]{form});
                target.add(new Component[]{TimeCardMain.this.tableView});
            }
        };
        this.recordViewForm.add(new Component[]{this.update2});
        this.tableView = new TableView("tableView", this.page){

            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            public void initializeMenu() {
            }

            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.tableView.setOutputMarkupId(true);
        this.recordViewForm.add(new Component[]{this.tableView});
        this.add(new Component[]{this.recordViewForm});
        this.showCurrentRecord();
    }

    private void showCurrentRecord() {
        this.tableView.clear();
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime todayStart = currentTime.withHour(0).withMinute(0).withSecond(0);
        String szCurrentTime = todayStart.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDateTime nextStart = todayStart.plusDays(1L);
        String szNextTime = nextStart.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String cmd = "select  TIME_RECORD_ID \u6253\u523bID, CHECK_DATE \u52e4\u52d9\u65e5, RECORD_DATETIME \u6253\u523b\u65e5\u6642, EMPLOYEE_NAME \u5f93\u696d\u8005, ORGANIZATION_NAME \u5834\u6240 from TIME_RECORD TR\ninner join EMPLOYEE E on\n  E.EMPLOYEE_ID = TR.EMPLOYEE_ID\ninner join ORGANIZATION O on\n  TR.ORGANIZATION_ID = O.ORGANIZATION_ID  where CHECK_DATE >= '%s' and CHECK_DATE < '%s' and TR.DISABLE = 0  order by RECORD_DATETIME desc";
        cmd = String.format(cmd, szCurrentTime, szNextTime);
        this.tableView.select(cmd);
    }

    public String getTitle() {
        return this.getSentence("\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9");
    }
}

