/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.autojob;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.plugin.scheduler.Job;

public class WorkReportEditor
extends Job {
    private int currNormalizer = 1;

    public WorkReportEditor(Jdbc controller) {
        super(controller);
    }

    public void execute() {
        ResultSet employees = this.getTargetEmployee();
        try {
            while (employees.next()) {
                this.currNormalizer = this.getNormalizeTime(employees.getString("EMPLOYEE_ID"));
                int recordCount = this.getRecordCount(employees.getInt("EMPLOYEE_ID"), employees.getString("CHECK_DATE"));
                String cmd = "merge into WORKTIME_REPORT(EMPLOYEE_ID, REC_DATE, MDATE, START_TIME, GOOUT_TIME, RETURN_TIME, END_TIME, WORK_TIME, BREAKE_TIME) values( %s, '%s', CURRENT_TIMESTAMP, '1900-01-01 0:0:0','1900-01-01 0:0:0','1900-01-01 0:0:0','1900-01-01 0:0:0',  0.0, 0.0)";
                cmd = String.format(cmd, employees.getInt("EMPLOYEE_ID"), employees.getString("CHECK_DATE"));
                this.getDataController().execute(cmd);
                if (recordCount > 0) {
                    ResultSet rawDatas = this.getTargetTimeRecord(employees);
                    String columns = "";
                    String values = "";
                    cmd = "merge into WORKTIME_REPORT(EMPLOYEE_ID, REC_DATE, MDATE, %s, STATUS)values(%s, '%s', CURRENT_TIMESTAMP, %s, 1)";
                    int count = 0;
                    while (rawDatas.next()) {
                        if (recordCount < 5) {
                            switch (count) {
                                case 0: {
                                    columns = columns + "START_TIME,";
                                    values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                                    break;
                                }
                                case 1: {
                                    if (recordCount < 3) {
                                        columns = columns + "END_TIME,";
                                        values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                                        break;
                                    }
                                    columns = columns + "GOOUT_TIME,";
                                    values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                                    break;
                                }
                                case 2: {
                                    columns = columns + "RETURN_TIME,";
                                    values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                                    break;
                                }
                                case 3: {
                                    columns = columns + "END_TIME,";
                                    values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                                }
                            }
                        } else {
                            if (count == 0) {
                                columns = columns + "START_TIME,";
                                values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                            }
                            if (count == recordCount - 1) {
                                columns = columns + "END_TIME,";
                                values = values + "'" + rawDatas.getTimestamp("RECORD_DATETIME").toString() + "',";
                            }
                        }
                        ++count;
                    }
                    columns = columns.substring(0, columns.length() - 1);
                    values = values.substring(0, values.length() - 1);
                    cmd = String.format(cmd, columns, employees.getInt("EMPLOYEE_ID"), employees.getString("CHECK_DATE"), values);
                    System.out.println(cmd);
                    this.getDataController().execute(cmd);
                }
                cmd = "update TIME_RECORD set STATUS = 0 where EMPLOYEE_ID = %d and CHECK_DATE='%s'";
                cmd = String.format(cmd, employees.getInt("EMPLOYEE_ID"), employees.getString("CHECK_DATE"));
                this.getDataController().execute(cmd);
            }
            employees.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int getRecordCount(int employeeId, String checkDate) {
        int rvalue = 0;
        String cmd = "Select count(*) reccount from TIME_RECORD where EMPLOYEE_ID = %d and CHECK_DATE = '%s' and DISABLE = 0";
        cmd = String.format(cmd, employeeId, checkDate);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                rvalue = rs.getInt("reccount");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private ResultSet getTargetTimeRecord(ResultSet rs) {
        ResultSet rvalue = null;
        try {
            int employeeId = rs.getInt("EMPLOYEE_ID");
            String dtime = rs.getString("CHECK_DATE");
            String cmd = "select EMPLOYEE_ID, CHECK_DATE, RECORD_DATETIME, ORGANIZATION_ID  from TIME_RECORD  where EMPLOYEE_ID = %d and CHECK_DATE = '%s' and DISABLE = 0  order by RECORD_DATETIME ";
            cmd = String.format(cmd, employeeId, dtime);
            rvalue = this.getDataController().select(cmd);
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private ResultSet getTargetEmployee() {
        String cmd = "select EMPLOYEE_ID, CHECK_DATE  from TIME_RECORD where STATUS = 1 GROUP BY EMPLOYEE_ID, CHECK_DATE ";
        ResultSet rs = this.getDataController().select(cmd);
        return rs;
    }

    private Timestamp normalize(Timestamp time, int count) {
        Timestamp rvalue = time;
        LocalDateTime t = rvalue.toLocalDateTime();
        int min = t.getMinute();
        if (count != 2) {
            int amari = min % this.currNormalizer;
            if (count % 2 == 1) {
                min = min / this.currNormalizer * this.currNormalizer;
                t = t.withMinute(min).withSecond(0).withNano(0);
            } else {
                min = min / this.currNormalizer * this.currNormalizer;
                if (amari > 0) {
                    min += this.currNormalizer;
                }
                t = t.withMinute(0).withSecond(0).withNano(0);
                t = t.plusMinutes(min);
            }
        } else {
            int div = min / this.currNormalizer;
            int amari = min % this.currNormalizer;
            if (amari > 0) {
                ++div;
            }
            min = div * this.currNormalizer;
            t = t.withMinute(0).withSecond(0).withNano(0).plusMinutes(min);
        }
        rvalue = Timestamp.valueOf(t);
        return rvalue;
    }

    private int getNormalizeTime(String employeeId) {
        int rvalue = 1;
        String cmd = "select NORMALIZE_TIME from EMPLOYEE where EMPLOYEE_ID = %s ";
        cmd = String.format(cmd, employeeId);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                rvalue = rs.getInt("NORMALIZE_TIME");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private String getOddRecordModifier(ResultSet timeRecord, int count) {
        String rvalue = "";
        try {
            rvalue = timeRecord.getString("RECORD_DATETIME");
            Timestamp tdate = timeRecord.getTimestamp("CHECK_DATE");
            Timestamp recDatetime = timeRecord.getTimestamp("RECORD_DATETIME");
            LocalDateTime targetDate = timeRecord.getTimestamp("CHECK_DATE").toLocalDateTime();
            LocalDateTime recLocDateTime = recDatetime.toLocalDateTime();
            int dayOfWeek = targetDate.getDayOfWeek().getValue();
            int orgId = timeRecord.getInt("ORGANIZATION_ID");
            String cmd = "select * from ORGANIZATION_BIZ_HOURS where ORGANIZATION_ID = %d and DAY_OF_WEEK = %d order by START_TIME ";
            cmd = String.format(cmd, orgId, dayOfWeek);
            System.out.println(cmd);
            ResultSet rs = this.getDataController().select(cmd);
            while (rs.next()) {
                Timestamp start = rs.getTimestamp("START_TIME");
                LocalDateTime lstart = start.toLocalDateTime();
                lstart = lstart.withYear(recLocDateTime.getYear()).withMonth(recLocDateTime.getMonthValue()).withDayOfMonth(recLocDateTime.getDayOfMonth());
                int eNum = rs.getInt("ENTRY_NUM");
                if (!recLocDateTime.isBefore(lstart)) continue;
                if (eNum == 1) {
                    recDatetime = Timestamp.valueOf(lstart);
                    continue;
                }
                long diff = recDatetime.getTime() - Timestamp.valueOf(lstart).getTime();
                if ((diff /= 3600000L) != 0L) continue;
                recDatetime = Timestamp.valueOf(lstart);
            }
            rs.close();
            recDatetime = this.normalize(recDatetime, count);
            rvalue = recDatetime.toString();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }
}

