/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.component;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySession;

public abstract class WorkTimeEdit
extends ClearfyContentHolder {
    public static final String WORKTYPE_UNDEFINED = "";
    public static final String WORKTYPE_NORMAL = "0";
    public static final String WORKTYPE_PAYEDHOLIDAY_FULL = "1";
    public static final String WORKTYPE_PAYEDHOLIDAY_HALF = "2";
    public static final String WORKTYPE_SPECIAL_HOLIDAY = "3";
    public static final String WORKTYPE_HOLIDAY_WORK = "4";
    public static final String WORKTYPE_OVERTIME = "5";
    private Form workTimeEditPanel;
    private Label selectedId;
    private Label selectedDatetime;
    private TextField timeInput;
    private int employeeId = -1;
    private ArrayList<String> typeCommandList;
    private Model<String> typeCommand;
    private RadioChoice<String> typeCommandRadio;
    private AjaxButton updateWorkType;

    public void setEmployeeId(int id) {
        this.employeeId = id;
    }

    public int getEmployeeId() {
        return this.employeeId;
    }

    public WorkTimeEdit(String id, ClearfyPage page) {
        super(id, page);
    }

    public void drawContent() {
        this.workTimeEditPanel = new Form("workTimeEditPanel");
        this.add(new Component[]{this.workTimeEditPanel});
        this.selectedId = new Label("selectedId", (IModel)Model.of((Serializable)((Object)WORKTYPE_UNDEFINED)));
        this.workTimeEditPanel.add(new Component[]{this.selectedId});
        this.selectedDatetime = new Label("selectedDatetime", (IModel)Model.of((Serializable)((Object)WORKTYPE_UNDEFINED)));
        this.workTimeEditPanel.add(new Component[]{this.selectedDatetime});
        this.timeInput = new TextField("timeInput", (IModel)Model.of((Serializable)((Object)WORKTYPE_UNDEFINED)));
        this.workTimeEditPanel.add(new Component[]{this.timeInput});
        if (!this.assertVisible()) {
            this.workTimeEditPanel.add(new Behavior[]{new AttributeModifier("style", (IModel)Model.of((Serializable)((Object)"display:none;")))});
        }
        this.typeCommand = Model.of((Serializable)((Object)this.getSentence(WORKTYPE_UNDEFINED)));
        this.typeCommandList = new ArrayList();
        this.typeCommandRadio = new RadioChoice("typeCommandRaido", this.typeCommand, this.typeCommandList);
        this.typeCommandList.add(this.getSentence("\u901a\u5e38\u52e4\u52d9"));
        this.typeCommandList.add(this.getSentence("\u6709\u4f11(\u5168\u4f11)"));
        this.typeCommandList.add(this.getSentence("\u6709\u4f11(\u534a\u4f11)"));
        this.typeCommandList.add(this.getSentence("\u7279\u4f11"));
        this.typeCommandList.add(this.getSentence("\u4f11\u51fa"));
        this.typeCommandList.add(this.getSentence("\u6b8b\u696d"));
        this.workTimeEditPanel.add(new Component[]{this.typeCommandRadio});
        this.updateWorkType = new AjaxButton("updateWorkType", (IModel)Model.of((Serializable)((Object)this.getSentence("\u66f4\u65b0")))){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                WorkTimeEdit.this.updateWorkTypeSubmitted(target, form);
            }
        };
        this.workTimeEditPanel.add(new Component[]{this.updateWorkType});
    }

    public void updateWorkTypeSubmitted(AjaxRequestTarget target, Form form) {
        if (this.selectedDatetime.getDefaultModelObjectAsString().length() < 1) {
            return;
        }
        if (this.employeeId < 1) {
            return;
        }
        String date = this.selectedDatetime.getDefaultModelObjectAsString();
        if (date.length() < 1) {
            return;
        }
        if (date.length() < 11) {
            date = date.trim() + " 00:00:00";
        }
        String selectedType = this.typeCommandRadio.getModelValue();
        Timestamp recdate = Timestamp.valueOf(date);
        String recDate = recdate.toLocalDateTime().toLocalDate().toString();
        String cmd = "merge into WORKTIME_REPORT  (%s) values(%s)";
        String updateField = WORKTYPE_UNDEFINED;
        String updateValue = WORKTYPE_UNDEFINED;
        boolean recalculate = false;
        switch (selectedType) {
            case "": {
                break;
            }
            case "0": {
                updateField = "EMPLOYEE_ID, REC_DATE,  MDATE, OVERTIME_COMMIT, PAID_HOLIDAY, SPECIAL_HOLIDAY, HOLIDAY_WORK, STATUS";
                updateValue = "%d, '%s',  CURRENT_TIMESTAMP,0, 0, 0, 0, 900";
                updateValue = String.format(updateValue, this.employeeId, recDate);
                cmd = String.format(cmd, updateField, updateValue);
                break;
            }
            case "1": {
                updateField = "EMPLOYEE_ID, REC_DATE,  MDATE, PAID_HOLIDAY, SPECIAL_HOLIDAY, HOLIDAY_WORK, STATUS";
                updateValue = "%d, '%s',  CURRENT_TIMESTAMP, 1, 0, 0, 900";
                updateValue = String.format(updateValue, this.employeeId, recDate);
                cmd = String.format(cmd, updateField, updateValue);
                break;
            }
            case "2": {
                updateField = "EMPLOYEE_ID, REC_DATE, MDATE, PAID_HOLIDAY, SPECIAL_HOLIDAY, HOLIDAY_WORK, STATUS";
                updateValue = "%d, '%s',  CURRENT_TIMESTAMP, 0.5, 0, 0, 900";
                updateValue = String.format(updateValue, this.employeeId, recDate);
                cmd = String.format(cmd, updateField, updateValue);
                break;
            }
            case "5": {
                updateField = "EMPLOYEE_ID, REC_DATE, MDATE, OVERTIME_COMMIT, STATUS";
                updateValue = "%d, '%s', CURRENT_TIMESTAMP, 1, 900";
                updateValue = String.format(updateValue, this.employeeId, recDate);
                cmd = String.format(cmd, updateField, updateValue);
            }
        }
        this.getDataController().execute(cmd);
        if (recalculate) {
            cmd = "update TIME_RECORD set STATUS = 1, MDATE = CURRENT_TIMESTAMP where EMPLOYEE_ID = %s and CHECK_DATE = '%s'";
            cmd = String.format(cmd, this.employeeId, recDate);
            this.getDataController().execute(cmd);
        }
        this.afterUpdated(target);
    }

    public abstract void afterUpdated(AjaxRequestTarget var1);

    public void setSelectedId(int id) {
        this.selectedId.setDefaultModel((IModel)Model.of((Serializable)Integer.valueOf(id)));
        String cmd = "select * from TIME_RECORD where TIME_RECORD_ID = %d";
        cmd = String.format(cmd, id);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                Timestamp ldt = rs.getTimestamp("RECORD_DATETIME");
                this.selectedDatetime.setDefaultModelObject((Object)ldt.toString());
                this.timeInput.setModelObject((Object)ldt.toString());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkTimeEdit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setSelectedDate(LocalDate date) {
        this.selectedDatetime.setDefaultModelObject((Object)date.toString());
        this.timeInput.setDefaultModelObject((Object)date.toString());
    }

    public LocalDate getSelectedDate() {
        String seldate = this.selectedDatetime.getDefaultModelObjectAsString();
        if (seldate.length() < 11) {
            seldate = seldate.trim() + " 00:00:00";
        }
        Timestamp stamp = Timestamp.valueOf(seldate);
        return stamp.toLocalDateTime().toLocalDate();
    }

    public void clear() {
        this.selectedId.setDefaultModelObject((Object)WORKTYPE_UNDEFINED);
        this.selectedDatetime.setDefaultModelObject((Object)WORKTYPE_UNDEFINED);
    }

    private boolean assertVisible() {
        boolean rvalue = false;
        String roles = ((ClearfySession)this.getSession()).getRoles().toString();
        if (roles == null) {
            rvalue = false;
        } else {
            if (roles.equals("MANAGEMENT_USER")) {
                rvalue = true;
            }
            if (roles.equals("ADMIN")) {
                rvalue = true;
            }
        }
        return rvalue;
    }

    public String getTitle() {
        return this.getSentence("\u7de8\u96c6\u30d5\u30a9\u30fc\u30e0");
    }

    public void initializeMenu() {
    }
}

