/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.component;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.tableview.Record;
import org.clearfy.plugin.timecard.component.CalendarTable;

public abstract class WorkingReportView
extends ClearfyContentHolder {
    private Label year;
    private Label month;
    private Label employeeId;
    private Label employeeName;
    private CalendarTable calendarTable;

    public WorkingReportView(String id, ClearfyPage page) {
        super(id, page);
    }

    public void setYear(int year) {
        this.year.setDefaultModel((IModel)Model.of((Serializable)Integer.valueOf(year)));
    }

    public int getYear() {
        return Integer.parseInt(this.year.getDefaultModelObjectAsString());
    }

    public void setMonth(int month) {
        this.month.setDefaultModel((IModel)Model.of((Serializable)Integer.valueOf(month)));
    }

    public int getMonth() {
        return Integer.parseInt(this.month.getDefaultModelObjectAsString());
    }

    public int getEmployeeId() {
        return Integer.parseInt(this.employeeId.getDefaultModelObjectAsString());
    }

    public void setEmployeeId(int eid) {
        this.employeeId.setDefaultModel((IModel)Model.of((Serializable)Integer.valueOf(eid)));
        String cmd = "select EMPLOYEE_ID, EMPLOYEE_NAME from EMPLOYEE where EMPLOYEE_ID = %d ";
        cmd = String.format(cmd, eid);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                String ename = rs.getString("EMPLOYEE_NAME");
                this.employeeName.setDefaultModel((IModel)Model.of((Serializable)((Object)ename)));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkingReportView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void drawContent() {
        LocalDate currdate = LocalDate.now();
        int curryear = currdate.getYear();
        int currmonth = currdate.getMonthValue();
        this.year = new Label("year", (IModel)Model.of((Serializable)Integer.valueOf(curryear)));
        this.add(new Component[]{this.year});
        this.month = new Label("month", (IModel)Model.of((Serializable)Integer.valueOf(currmonth)));
        this.add(new Component[]{this.month});
        this.employeeId = new Label("employeeId", (IModel)Model.of((Serializable)((Object)"-1")));
        this.add(new Component[]{this.employeeId});
        this.employeeName = new Label("employeeName", (IModel)Model.of((Serializable)((Object)"")));
        this.add(new Component[]{this.employeeName});
        this.calendarTable = new CalendarTable("calendarTable", this.page){

            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                WorkingReportView.this.onRowClicked(target, this.selected);
            }
        };
        this.calendarTable.setItemsPerPage(31L);
        this.add(new ClearfyContentHolder[]{this.calendarTable});
    }

    public String getTitle() {
        return this.getSentence("\u52e4\u52d9\u8868");
    }

    public void initializeMenu() {
    }

    public void drawWorkingReport() {
        if (this.assertParameter()) {
            this.calendarTable.drawCalendar(this.getYear(), this.getMonth());
            this.calendarTable.setDayFieldName(this.getSentence("\u65e5\u4ed8"));
            LocalDate from = LocalDate.of(this.getYear(), this.getMonth(), 1);
            LocalDate to = from.plusMonths(1L);
            String cmd = "Select REC_DATE \u65e5\u4ed8,\n formatdatetime(START_TIME,'HH:mm') \u958b\u59cb,\n formatdatetime(GOOUT_TIME,'HH:mm') \u5916\u51fa,\n formatdatetime(RETURN_TIME,'HH:mm') \u5e30\u7740,\n formatdatetime(END_TIME,'HH:mm') \u9000\u51fa,\n convert(WORK_TIME, decimal(18,2)) \u52e4\u52d9\u6642\u9593,\n convert(BREAKE_TIME, decimal(18,2)) \u4f11\u61a9,\n convert(OVER_TIME, decimal(18,2)) \u6b8b\u696d,\n convert(LATENIGHT_TIME,decimal(18,2)) \u6df1\u591c,\nOVERTIME_COMMIT \u6b8b\u5831,\nconvert(PAID_HOLIDAY, decimal(18,2)) \u6709\u4f11,\nSPECIAL_HOLIDAY \u7279\u4f11,\nHOLIDAY_WORK  \u4f11\u51fa,\n STATUS, DETAIL_INFO \u8a73\u7d30\nfrom WORKTIME_REPORT where EMPLOYEE_ID = %d and  REC_DATE >= '%s' and REC_DATE < '%s' ";
            cmd = String.format(cmd, Integer.parseInt(this.employeeId.getDefaultModelObjectAsString()), String.format("%d-%d-%d", from.getYear(), from.getMonthValue(), from.getDayOfMonth()), String.format("%d-%d-%d", to.getYear(), to.getMonthValue(), to.getDayOfMonth()));
            this.calendarTable.select(cmd);
        }
    }

    public abstract void onRowClicked(AjaxRequestTarget var1, Record var2);

    private boolean assertParameter() {
        boolean rvalue = false;
        if (Integer.parseInt(this.year.getDefaultModelObjectAsString()) < 9999 && Integer.parseInt(this.month.getDefaultModelObjectAsString()) < 99 && Integer.parseInt(this.employeeId.getDefaultModelObjectAsString()) > 0) {
            rvalue = true;
        }
        System.out.println("ASSERT PARAM : " + rvalue);
        return rvalue;
    }
}

