<?php

/*
 * ɤΥСɽ
 * $Id: index.php,v 1.14 2003/01/11 17:49:35 yuryu Exp $
 *
 */


require_once("./common.php");
require_once("./clist.php");
require_once("./plist.php");
require_once("./settings.php");


show_header(PAGE_TITLE);

include('index.header.php');

show_list();

include('index.footer.php');

show_footer();



function show_list()
{
	global $charlist_columns;

	if($_REQUEST['sort']){
		$sort_order = $_REQUEST['sort'];
	}else{
		$sort_order = false;
	}
	
	$column_text = '';
	foreach($charlist_columns as $id => $column){
		$class = $id;
		if($_REQUEST['detail'] != 'true' and $column['hidedefault']){
			continue;
		}
		$sortopt = 'sort=' . $id;
		if($sort_order == $id){
			$class .= ' selected';
		}
		if($sort_order == $id and $_REQUEST['reverse'] != 'true'){
			$sortopt .=  '&amp;reverse=true';
		}
		
		if($_REQUEST['detail']){
			$sortopt .= '&amp;detail=true';
		}
		
		$column_text .= sprintf("<th title='%s' class='%s'><a href='./?%s'>%s</a></th>", $column['desc'], $class, $sortopt, $column['title']);
	}

	print("<table border='1' id='charactertable'><thead><tr>$column_text</tr></thead><tfoot><tr>$column_text</tr></tfoot><tbody>");
	

	$charlist = new CharacterList(CHARDATA_FNAME);
	$characters = $charlist -> get_list($sort_order, ($_REQUEST['reverse'] == 'true') xor $charlist_columns[$sort_order]['reverse']);
	foreach($characters as $character){
		$character = a_htmlspecialchars($character);
		if($character['main'] == 'true'){
			print("<tr class='mainchar'>");
		}else{
			print("<tr class='subchar'>");
		}
		foreach($charlist_columns as $id => $column){
			if($_REQUEST['detail'] != 'true' and $column['hidedefault']){
				continue;
			}
			if($column['callback'] and function_exists($column['callback'])){
				call_user_func($column['callback'], $id, $character);
			}else{
				$class = '';
				if($column['class']){
					$class = 'class="' . $column['class'] . '"';
				}
				printf("<td %s>%s</td>", $class, $character[$id]);
			}
		}
		print("</tr>\n");
		
	}
	
	print("</tbody></table>");
}

?>
